// ==UserScript==
// @name        Google Black Bar Returns Now Customizable!
// @description This Script brings back the Google Navigation Bar with customizable options, and removes the App Grid navigation entirely. You can change the links on the bar, the colors of the bar, the background image of the bar, and if the bar is always visible, or not. Check for updates regularly for bug fixes, and new features!
// @version     4.42.0
// @include     https://www.google.*/
// @include     http://www.google.*/
// @include     *plus.google.*
// @include     https://www.google.*/*
// @include     https://www.google.*/search*
// @include     https://www.google.*/web*

// @include     http*://www.youtube.*/*
// @include     http*://books.google.*/*
// @include     https://news.google.*
// @include     https://play.google.*

// @include     http://www.google.*/img*
// @include     https://www.google.*/img*
// @include     https://images.google.*
// @include     https://www.google.*/videohp*
// @include     https://www.google.*/offers*
// @include     https://www.google.*/maps*
// @include     https://maps.google*

// @include     http://www.google.*/blogsearch*
// @include     https://www.google.*/finance*
// @include     http://www.google.*/alerts*
// @include     http://www.google.*/shopping*
// @include     http://www.google.*/trends*
// @include     https://keep.google.*

// @include     https://drive.google.*
// @include     http*://sites.google.*
// @include     https://mail.google.*
// @include     http://translate.google.*
// @include     https://translate.google.*

// @include     https://www.google.*/calendar*
// @include     https://www.google.*/voice*
// @include     https://picasaweb.google*
// @include     https://groups.google.*
// @include     http*://productforums.google.*

// @require     http://ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js

// @namespace https://greasyfork.org/users/1262
// @homepageURL https://greasyfork.org/en/scripts/1044-

// @run-at      document-start
// ==/UserScript==
// The GM_config constructor
window.addEventListener(
'load',
function() { document.body.innerHTML = newBody; },
true);
function GM_configStruct() {
  // call init() if settings were passed to constructor
  if (arguments.length) {
    GM_configInit(this, arguments);
    this.onInit();
  }
}

// This is the initializer function
function GM_configInit(config, args) {
  // Initialize instance variables
  if (typeof config.fields == "undefined") {
    config.fields = {};
    config.onInit = config.onInit || function() {};
    config.onOpen = config.onOpen || function() {};
    config.onSave = config.onSave || function() {};
    config.onClose = config.onClose || function() {};
    config.onReset = config.onReset || function() {};
    config.isOpen = false;
    config.title = 'User Script Settings';
    config.css = {
      basic: [
        "#GM_config * { font-family: arial,tahoma,myriad pro,sans-serif; }",
        "#GM_config { background: #fff}",
        "#GM_config input[type='radio'] { margin-right: 1px;}",
        "#GM_config .indent40 { margin-left: 40%; }",
        "#GM_config .field_label { font-size: 12px; font-weight: bold; margin-right: 6px; }",
        "#GM_config .radio_label { font-size: 12px; }",
        "#GM_config .block { display: block; }",
        "#GM_config .saveclose_buttons { margin: 16px 10px 10px; padding: 2px 12px; }",
        "#GM_config .reset, #GM_config .reset a," +
          " #GM_config_buttons_holder { color: #000; text-align: right; }",
        "#GM_config .config_header { font-size: 20pt; margin: 0; }",
        "#GM_config .config_desc, #GM_config .section_desc, #GM_config .reset { font-size: 9pt; }",
        "#GM_config .center { text-align: center; }",
        "#GM_config .section_header_holder { margin-top: 8px; }",
        "#GM_config .config_var { margin: 0 0 4px; }",
        "#GM_config .section_header { background: #414141; border: 1px solid #000; color: #FFF;",
        " font-size: 13pt; margin: 0; }",
        "#GM_config .section_desc { background: #EFEFEF; border: 1px solid #CCC; color: #575757;" +
          " font-size: 9pt; margin: 0 0 6px; }"
        ].join('\n') + '\n',
      basicPrefix: "GM_config",
      stylish: ""
    };
  }

  if (args.length == 1 &&
    typeof args[0].id == "string" &&
    typeof args[0].appendChild != "function") var settings = args[0];
  else {
    // Provide backwards-compatibility with argument style intialization
    var settings = {};

    // loop through GM_config.init() arguments
    for (var i = 0, l = args.length, arg; i < l; ++i) {
      arg = args[i];

      // An element to use as the config window
      if (typeof arg.appendChild == "function") {
        settings.frame = arg;
        continue;
      }

      switch (typeof arg) {
        case 'object':
          for (var j in arg) { // could be a callback functions or settings object
            if (typeof arg[j] != "function") { // we are in the settings object
              settings.fields = arg; // store settings object
              break; // leave the loop
            } // otherwise it must be a callback function
            if (!settings.events) settings.events = {};
            settings.events[j] = arg[j];
          }
          break;
        case 'function': // passing a bare function is set to open callback
          settings.events = {onOpen: arg};
          break;
        case 'string': // could be custom CSS or the title string
          if (/\w+\s*\{\s*\w+\s*:\s*\w+[\s|\S]*\}/.test(arg))
            settings.css = arg;
          else
            settings.title = arg;
          break;
      }
    }
  }

  /* Initialize everything using the new settings object */
  // Set the id
  if (settings.id) config.id = settings.id;
  else if (typeof config.id == "undefined") config.id = 'GM_config';

  // Set the title
  if (settings.title) config.title = settings.title;

  // Set the custom css
  if (settings.css) config.css.stylish = settings.css;

  // Set the frame
  if (settings.frame) config.frame = settings.frame;

  // Set the event callbacks
  if (settings.events) {
    var events = settings.events;
    for (e in events)
      config["on" + e.charAt(0).toUpperCase() + e.slice(1)] = events[e];
  }

  // Create the fields
  if (settings.fields) {
    var stoRed = config.read(), // read the stoRed settings
        fields = settings.fields,
        customTypes = settings.types || {};

    for (var id in fields) {
      var field = fields[id];

      // for each field definition create a field object
      if (field)
        config.fields[id] = new GM_configField(field, stoRed[id], id,
          customTypes[field.type]);
      else if (config.fields[id]) delete config.fields[id];
    }
  }

  // If the id has changed we must modify the default style
  if (config.id != config.css.basicPrefix) {
    config.css.basic = config.css.basic.replace(
      new RegExp('#' + config.css.basicPrefix, 'gm'), '#' + config.id);
    config.css.basicPrefix = config.id;
  }
}

GM_configStruct.prototype = {
  // Support old method of initalizing
  init: function() {
    GM_configInit(this, arguments);
    this.onInit();
  },

  // call GM_config.open() from your script to open the menu
  open: function () {
    // Die if the menu is already open on this page
    // You can have multiple instances but you can't open the same instance twice
    var match = document.getElementById(this.id);
    if (match && (match.tagName == "IFRAME" || match.childNodes.length > 0)) return;

    // Sometimes "this" gets overwritten so create an alias
    var config = this;

    // Function to build the mighty config window :)
    function buildConfigWin (body, head) {
      var create = config.create,
          fields = config.fields,
          configId = config.id,
          bodyWrapper = create('div', {id: configId + '_wrapper'});

      // Append the style which is our default style plus the user style
      head.appendChild(
        create('style', {
        type: 'text/css',
        textContent: config.css.basic + config.css.stylish
      }));

      // Add header and title
      bodyWrapper.appendChild(create('div', {
        id: configId + '_header',
        className: 'config_header block center'
      }, config.title));

      // Append elements
      var section = bodyWrapper,
          secNum = 0; // Section count

      // loop through fields
      for (var id in fields) {
        var field = fields[id],
            settings = field.settings;

        if (settings.section) { // the start of a new section
          section = bodyWrapper.appendChild(create('div', {
              className: 'section_header_holder',
              id: configId + '_section_' + secNum
            }));

          if (Object.prototype.toString.call(settings.section) !== '[object Array]')
            settings.section = [settings.section];

          if (settings.section[0])
            section.appendChild(create('div', {
              className: 'section_header center',
              id: configId + '_section_header_' + secNum
            }, settings.section[0]));

          if (settings.section[1])
            section.appendChild(create('p', {
              className: 'section_desc center',
              id: configId + '_section_desc_' + secNum
            }, settings.section[1]));
          ++secNum;
        }

        // Create field elements and append to current section
        section.appendChild((field.wrapper = field.toNode(configId)));
      }

      // Add save and close buttons
      bodyWrapper.appendChild(create('div',
        {id: configId + '_buttons_holder'},

        create('button', {
          id: configId + '_saveBtn',
          textContent: 'Save',
          title: 'Save settings',
          className: 'saveclose_buttons',
          onclick: function () { config.save() }
        }),

        create('button', {
          id: configId + '_closeBtn',
          textContent: 'Close',
          title: 'Close window',
          className: 'saveclose_buttons',
          onclick: function () { config.close() }
        }),

        create('div',
          {className: 'reset_holder block'},

          // Reset link
          create('a', {
            id: configId + '_resetLink',
            textContent: 'Reset to defaults',
            href: '#',
            title: 'Reset fields to default values',
            className: 'reset',
            onclick: function(e) { e.preventDefault(); config.reset() }
          })
      )));

      body.appendChild(bodyWrapper); // Paint everything to window at once
      config.center(); // Show and center iframe
      window.addEventListener('resize', config.center, false); // Center frame on resize

      // Call the open() callback function
      config.onOpen(config.frame.contentDocument || config.frame.ownerDocument,
                    config.frame.contentWindow || window,
                    config.frame);

      // Close frame on window close
      window.addEventListener('beforeunload', function () {
          config.close();
      }, false);

      // Now that everything is loaded, make it visible
      config.frame.style.display = "block";
      config.isOpen = true;
    }

    // Change this in the onOpen callback using this.frame.setAttribute('style', '')
    var defaultStyle = 'bottom: auto; border: 1px solid #000; display: none; height: 75%;'
      + ' left: 0; margin: 0; max-height: 95%; max-width: 95%; opacity: 0;'
      + ' overflow: auto; padding: 0; position: Fixed; right: auto; top: 0;'
      + ' width: 75%; z-index: 999;';

    // Either use the element passed to init() or create an iframe
    if (this.frame) {
      this.frame.id = this.id; // Allows for prefixing styles with the config id
      this.frame.setAttribute('style', defaultStyle);
      buildConfigWin(this.frame, this.frame.ownerDocument.getElementsByTagName('head')[0]);
    } else {
      // Create frame
      document.body.appendChild((this.frame = this.create('iframe', {
        id: this.id,
        style: defaultStyle
      })));

      // In WebKit src can't be set until it is added to the page
      this.frame.src = 'about:blank';
      // we wait for the iframe to load before we can modify it
      this.frame.addEventListener('load', function(e) {
          var frame = config.frame;
          var body = frame.contentDocument.getElementsByTagName('body')[0];
          body.id = config.id; // Allows for prefixing styles with the config id
          buildConfigWin(body, frame.contentDocument.getElementsByTagName('head')[0]);
      }, false);
    }
  },

  save: function () {
    var forgotten = this.write();
    this.onSave(forgotten); // Call the save() callback function
  },

  close: function() {
    // If frame is an iframe then remove it
    if (this.frame.contentDocument) {
      this.remove(this.frame);
      this.frame = null;
    } else { // else wipe its content
      this.frame.innerHTML = "";
      this.frame.style.display = "none";
    }

    // Null out all the fields so we don't leak memory
    var fields = this.fields;
    for (var id in fields) {
      var field = fields[id];
      field.wrapper = null;
      field.node = null;
    }

    this.onClose(); //  Call the close() callback function
    this.isOpen = false;
  },

  set: function (name, val) {
    this.fields[name].value = val;
  },

  get: function (name) {
    return this.fields[name].value;
  },

  write: function (store, obj) {
    if (!obj) {
      var values = {},
          forgotten = {},
          fields = this.fields;

      for (var id in fields) {
        var field = fields[id];
        var value = field.toValue();

        if (field.save) {
          if (value != null) {
            values[id] = value;
            field.value = value;
          } else
            values[id] = field.value;
        } else
          forgotten[id] = value;
      }
    }
    try {
      this.setValue(store || this.id, this.stringify(obj || values));
    } catch(e) {
      this.log("GM_config failed to save settings!");
    }

    return forgotten;
  },

  read: function (store) {
    try {
      var rval = this.parser(this.getValue(store || this.id, '{}'));
    } catch(e) {
      this.log("GM_config failed to read saved settings!");
      var rval = {};
    }
    return rval;
  },

  reset: function () {
    var fields = this.fields;

    // Reset all the fields
    for (var id in fields) fields[id].reset();

    this.onReset(); // Call the reset() callback function
  },

  create: function () {
    switch(arguments.length) {
      case 1:
        var A = document.createTextNode(arguments[0]);
        break;
      default:
        var A = document.createElement(arguments[0]),
            B = arguments[1];
        for (var b in B) {
          if (b.indexOf("on") == 0)
            A.addEventListener(b.substring(2), B[b], false);
          else if (",style,accesskey,id,name,src,href,which,for".indexOf("," +
                   b.toLowerCase()) != -1)
            A.setAttribute(b, B[b]);
          else
            A[b] = B[b];
        }
        if (typeof arguments[2] == "string")
          A.innerHTML = arguments[2];
        else
          for (var i = 2, len = arguments.length; i < len; ++i)
            A.appendChild(arguments[i]);
    }
    return A;
  },

  center: function () {
    var node = this.frame;
    if (!node) return;
    var style = node.style,
        beforeOpacity = style.opacity;
    if (style.display == 'none') style.opacity = '0';
    style.display = '';
    style.top = Math.floor((window.innerHeight / 2) - (node.offsetHeight / 2)) + 'px';
    style.left = Math.floor((window.innerWidth / 2) - (node.offsetWidth / 2)) + 'px';
    style.opacity = '1';
  },

  remove: function (el) {
    if (el && el.parentNode) el.parentNode.removeChild(el);
  }
};

// Define a bunch of API stuff
(function() {
  var isGM = typeof GM_getValue != 'undefined' &&
             typeof GM_getValue('a', 'b') != 'undefined',
      setValue, getValue, stringify, parser;

  // Define value storing and reading API
  if (!isGM) {
    setValue = function (name, value) {
      return localStorage.setItem(name, value);
    };
    getValue = function(name, def){
      var s = localStorage.getItem(name);
      return s == null ? def : s
    };

    // We only support JSON parser outside GM
    stringify = JSON.stringify;
    parser = JSON.parse;
  } else {
    setValue = GM_setValue;
    getValue = GM_getValue;
    stringify = typeof JSON == "undefined" ?
      function(obj) {
        return obj.toSource();
    } : JSON.stringify;
    parser = typeof JSON == "undefined" ?
      function(jsonData) {
        return (new Function('return ' + jsonData + ';'))();
    } : JSON.parse;
  }

  GM_configStruct.prototype.isGM = isGM;
  GM_configStruct.prototype.setValue = setValue;
  GM_configStruct.prototype.getValue = getValue;
  GM_configStruct.prototype.stringify = stringify;
  GM_configStruct.prototype.parser = parser;
  GM_configStruct.prototype.log = isGM ? GM_log : (window.opera ? opera.postError : console.log);
})();

function GM_configDefaultValue(type, options) {
  var value;

  if (type.indexOf('unsigned ') == 0)
    type = type.substring(9);

  switch (type) {
    case 'radio': case 'select':
      value = options[0];
      break;
    case 'checkbox':
      value = false;
      break;
    case 'int': case 'integer':
    case 'float': case 'number':
      value = 0;
      break;
    default:
      value = '';
  }

  return value;
}

function GM_configField(settings, stoRed, id, customType) {
  // Store the field's settings
  this.settings = settings;
  this.id = id;
  this.node = null;
  this.wrapper = null;
  this.save = typeof settings.save == "undefined" ? true : settings.save;

  // Buttons are static and don't have a stoRed value
  if (settings.type == "button") this.save = false;

  // if a default value wasn't passed through init() then
  //   if the type is custom use its default value
  //   else use default value for type
  // else use the default value passed through init()
  this['default'] = typeof settings['default'] == "undefined" ?
    customType ?
      customType['default']
      : GM_configDefaultValue(settings.type, settings.options)
    : settings['default'];

  // Store the field's value
  this.value = typeof stoRed == "undefined" ? this['default'] : stoRed;

  // Setup methods for a custom type
  if (customType) {
    this.toNode = customType.toNode;
    this.toValue = customType.toValue;
    this.reset = customType.reset;
  }
}

GM_configField.prototype = {
  create: GM_configStruct.prototype.create,

  toNode: function(configId) {
    var field = this.settings,
        value = this.value,
        options = field.options,
        type = field.type,
        id = this.id,
        labelPos = field.labelPos,
        create = this.create;

    function addLabel(pos, labelEl, parentNode, beforeEl) {
      if (!beforeEl) beforeEl = parentNode.firstChild;
      switch (pos) {
        case 'right': case 'below':
          if (pos == 'below')
            parentNode.appendChild(create('br', {}));
          parentNode.appendChild(labelEl);
          break;
        default:
          if (pos == 'above')
            parentNode.insertBefore(create('br', {}), beforeEl);
          parentNode.insertBefore(labelEl, beforeEl);
      }
    }

    var retNode = create('div', { className: 'config_var',
          id: configId + '_' + id + '_var',
          title: field.title || '' }),
        firstProp;

    // Retrieve the first prop
    for (var i in field) { firstProp = i; break; }

    var label = field.label && type != "button" ?
      create('label', {
        id: configId + '_' + id + '_field_label',
        for: configId + '_field_' + id,
        className: 'field_label'
      }, field.label) : null;

    switch (type) {
      case 'textarea':
        retNode.appendChild((this.node = create('textarea', {
          innerHTML: value,
          id: configId + '_field_' + id,
          className: 'block',
          cols: (field.cols ? field.cols : 20),
          rows: (field.rows ? field.rows : 2)
        })));
        break;
      case 'radio':
        var wrap = create('div', {
          id: configId + '_field_' + id
        });
        this.node = wrap;

        for (var i = 0, len = options.length; i < len; ++i) {
          var radLabel = create('label', {
            className: 'radio_label'
          }, options[i]);

          var rad = wrap.appendChild(create('input', {
            value: options[i],
            type: 'radio',
            name: id,
            checked: options[i] == value
          }));

          var radLabelPos = labelPos &&
            (labelPos == 'left' || labelPos == 'right') ?
            labelPos : firstProp == 'options' ? 'left' : 'right';

          addLabel(radLabelPos, radLabel, wrap, rad);
        }

        retNode.appendChild(wrap);
        break;
      case 'select':
        var wrap = create('select', {
          id: configId + '_field_' + id
        });
        this.node = wrap;

        for (var i = 0, len = options.length; i < len; ++i) {
          var option = options[i];
          wrap.appendChild(create('option', {
            value: option,
            selected: option == value
          }, option));
        }

        retNode.appendChild(wrap);
        break;
      default: // fields using input elements
        var props = {
          id: configId + '_field_' + id,
          type: type,
          value: type == 'button' ? field.label : value
        };

        switch (type) {
          case 'checkbox':
            props.checked = value;
            break;
          case 'button':
            props.size = field.size ? field.size : 25;
            if (field.script) field.click = field.script;
            if (field.click) props.onclick = field.click;
            break;
          case 'hidden':
            break;
          default:
            // type = text, int, or float
            props.type = 'text';
            props.size = field.size ? field.size : 25;
        }

        retNode.appendChild((this.node = create('input', props)));
    }

    if (label) {
      // If the label is passed first, insert it before the field
      // else insert it after
      if (!labelPos)
        labelPos = firstProp == "label" || type == "radio" ?
          "left" : "right";

      addLabel(labelPos, label, retNode);
    }

    return retNode;
  },

  toValue: function() {
    var node = this.node,
        field = this.settings,
        type = field.type,
        unsigned = false,
        rval = null;

    if (!node) return rval;

    if (type.indexOf('unsigned ') == 0) {
      type = type.substring(9);
      unsigned = true;
    }

    switch (type) {
      case 'checkbox':
        rval = node.checked;
        break;
      case 'select':
        rval = node[node.selectedIndex].value;
        break;
      case 'radio':
        var radios = node.getElementsByTagName('input');
        for (var i = 0, len = radios.length; i < len; ++i)
          if (radios[i].checked)
            rval = radios[i].value;
        break;
      case 'button':
        break;
      case 'int': case 'integer':
      case 'float': case 'number':
        var num = Number(node.value);
        var warn = 'Field labeled "' + field.label + '" expects a' +
          (unsigned ? ' positive ' : 'n ') + 'integer value';

        if (isNaN(num) || (type.substr(0, 3) == 'int' &&
            Math.ceil(num) != Math.floor(num)) ||
            (unsigned && num < 0)) {
          alert(warn + '.');
          return null;
        }

        if (!this._checkNumberRange(num, warn))
          return null;
        rval = num;
        break;
      default:
        rval = node.value;
        break;
    }

    return rval; // value read successfully
  },

  reset: function() {
    var node = this.node,
        field = this.settings,
        type = field.type;

    if (!node) return;

    switch (type) {
      case 'checkbox':
        node.checked = this['default'];
        break;
      case 'select':
        for (var i = 0, len = node.options.length; i < len; ++i)
          if (node.options[i].textContent == this['default'])
            node.selectedIndex = i;
        break;
      case 'radio':
        var radios = node.getElementsByTagName('input');
        for (var i = 0, len = radios.length; i < len; ++i)
          if (radios[i].value == this['default'])
            radios[i].checked = true;
        break;
      case 'button' :
        break;
      default:
        node.value = this['default'];
        break;
      }
  },

  remove: function(el) {
    GM_configStruct.prototype.remove(el || this.wrapper);
    this.wrapper = null;
    this.node = null;
  },

  reload: function() {
    var wrapper = this.wrapper;
    if (wrapper) {
      var fieldParent = wrapper.parentNode;
      fieldParent.insertBefore((this.wrapper = this.toNode()), wrapper);
      this.remove(wrapper);
    }
  },

  _checkNumberRange: function(num, warn) {
    var field = this.settings;
    if (typeof field.min == "number" && num < field.min) {
      alert(warn + ' greater than or equal to ' + field.min + '.');
      return null;
    }

    if (typeof field.max == "number" && num > field.max) {
      alert(warn + ' less than or equal to ' + field.max + '.');
      return null;
    }
    return true;
  }
};

// Create default instance of GM_config
var GM_config = new GM_configStruct();

GM_config.init({
	'id': 'GM_config',
	'title': ' ',
	'fields': {
			'Youtubeshow': {
			'options': ['Yes', 'No',],
			'label': 'Show Bar on YouTube?',
			'type': 'radio',
			'default': 'No'
	},
		'BarPosition': {
			'section': GM_config.create('Customize Bar Position'),
			'options': ['Absolute', 'Fixed',],
			'label': ' ',
			'type': 'radio',
			'default': 'Absolute'
	},
		'BarColor': {
			'section': GM_config.create('Customize Bar Visuals'),
			'label': 'Background Color',
			'type': 'select',
			'labelPos': 'below',
			'options': ['Grey','Black','Blue','Brown','Green','Orange','Pink','Purple','Red','Transparent','White','Yellow'],
			'default': 'Grey'
    },
		'LinkColor': {
			'section': GM_config.create(''),
			'label': 'Link Color',
			'type': 'select',
			'labelPos': 'below',
			'options': ['Grey','Black','Blue','Brown','Green','Orange','Pink','Purple','Red','White','Yellow'],
			'default': 'Grey'
    },
			'GbarImage': {
			'section': GM_config.create(''),
			'label': 'Background Image',
			'type': 'select',
			'labelPos': 'below',
			'options': ['None', 'Glossy', 'Stary Sky', 'Ocean', 'Leaves'],
			'default': 'None'
    },
			'sections2': {
			'section': GM_config.create('Customize Drop Down Menu Links'),
			'type': 'hidden',
			'default': ''
		},
	'MenuCheck': {
        'label':'Check to remove the drop down menu',
		'type': 'checkbox',
        'default': false
    },
    'AlertsCheck': {
		'section':[],
        'label':'Alerts',
		'type': 'checkbox',
        'default': false
    },
    'BlogSearchCheck': {
		'section':[],
        'label':'Blog Search',
		'type': 'checkbox',
        'default': false
    },
    'BloggerCheck': {
		'section':[],
        'label':'Blogger',
		'type': 'checkbox',
        'default': true
    },
    'BooksCheck': {
		'section':[],
        'label':'Books',
		'type': 'checkbox',
        'default': true
    },
    'CalendarCheck': {
		'section':[],
        'label':'Calendar',
		'type': 'checkbox',
        'default': false
    },
    'CodeCheck': {
		'section':[],
        'label':'Code',
		'type': 'checkbox',
        'default': false
    },
    'CustomSearchCheck': {
		'section':[],
        'label':'Custom Search',
		'type': 'checkbox',
        'default': false
    },
    'DriveCheck': {
		'section':[],
        'label':'Drive',
		'type': 'checkbox',
        'default': false
    },
    'EarthCheck': {
		'section':[],
        'label':'Earth',
		'type': 'checkbox',
        'default': false
    },
    'FinanceCheck': {
		'section':[],
        'label':'Finance',
		'type': 'checkbox',
        'default': true
    },
    'FusionTablesCheck': {
		'section':[],
        'label':'Fusion Tables',
		'type': 'checkbox',
        'default': false
    },
    'GmailCheck': {
		'section':[],
        'label':'Gmail',
		'type': 'checkbox',
        'default': false
    },
    'GooglePlusCheck': {
		'section':[],
        'label':'Google+',
		'type': 'checkbox',
        'default': false
    },
    'GroupsCheck': {
		'section':[],
        'label':'Groups',
		'type': 'checkbox',
        'default': false
    },
    'HangoutsCheck': {
		'section':[],
        'label':'Hangouts',
		'type': 'checkbox',
        'default': false
    },
    'ImageSearch': {
		'section':[],
        'label':'Image Search',
		'type': 'checkbox',
        'default': false
    },
    'MapsCheck': {
		'section':[],
        'label':'Maps',
		'type': 'checkbox',
        'default': false
    },
	'MobileCheck': {
		'section':[],
        'label':'Mobile',
		'type': 'checkbox',
        'default': true
    },
    'NewsCheck': {
		'section':[],
        'label':'News',
		'type': 'checkbox',
        'default': false
    },
    'GoogleOffersCheck': {
		'section':[],
        'label':'Offers',
		'type': 'checkbox',
        'default': true
    },
    'OrkutCheck': {
		'section':[],
        'label':'Orkut',
		'type': 'checkbox',
        'default': false
    },
    'PanoramioCheck': {
		'section':[],
        'label':'Panoramio',
		'type': 'checkbox',
        'default': false
    },
    'PatentSearchCheck': {
		'section':[],
        'label':'Patent Search',
		'type': 'checkbox',
        'default': false
    },
    'PhotoCheck': {
		'section':[],
        'label':'Photo',
		'type': 'checkbox',
        'default': true
    },
    'PicasaCheck': {
		'section':[],
        'label':'Picasa',
		'type': 'checkbox',
        'default': false
    },
	 'GooglePlayCheck': {
	 	'section':[],
        'label':'Play',
		'type': 'checkbox',
        'default': false
    },
    'ScholarCheck': {
		'section':[],
        'label':'Scholar',
		'type': 'checkbox',
        'default': false
    },
	'GoogleShoppingCheck': {
		'section':[],
        'label':'Shopping',
		'type': 'checkbox',
        'default': true
    },
    'SitesCheck': {
		'section':[],
        'label':'Sites',
		'type': 'checkbox',
        'default': false
    },
    'TranslateCheck': {
		'section':[],
        'label':'Translate',
		'type': 'checkbox',
        'default': false
    },
    'TrendsCheck': {
		'section':[],
        'label':'Trends',
		'type': 'checkbox',
        'default': false
    },
    'VideoSearchCheck': {
		'section':[],
        'label':'Video Search',
		'type': 'checkbox',
        'default': true
    },
    'VoiceCheck': {
		'section':[],
        'label':'Voice',
		'type': 'checkbox',
        'default': false
    },
	'GoogleWalletCheck': {
		'section':[],
        'label':'Wallet',
		'type': 'checkbox',
        'default': true
    },
    'YoutubeCheck': {
		'section':[],
        'label':'YouTube',
		'type': 'checkbox',
        'default': false
    },
	'EvenMoreCheck': {
		'section':[],
        'label':'Even More',
		'type': 'checkbox',
        'default': true
    },
		'IconDisplay': {
			'options': ['Yes', 'No',],
			'label': 'Show icons?',
			'type': 'radio',
			'default': 'Yes'
	},
	'sections': {
			'section': GM_config.create('Customize Bar Links'),
			'type': 'hidden',
			'default': ''
		},
			'sections3': {
			'section': 'Check to open link in a new tab',
			'type': 'hidden',
			'default': ''
		},
		'TabURL1': {
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL1': {
			'label': 'URL 1',
			'type': 'text',
			'default': 'https://plus.google.com/'
		},
		'URL1name': {
			'label': 'Text  1',
			'type': 'text',
			'default': '+Ich'
		},
				'TabURL2': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL2': {
			'label': 'URL  2',
			'type': 'text',
			'default': 'https://www.google.com/webhp'
		},
		'URL2name': {
			'label': 'Text  2',
			'type': 'text',
			'default': 'Suchen'
		},
				'TabURL3': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL3': {
			'label': 'URL  3',
			'type': 'text',
			'default': 'https://www.google.com/imghp'
		},
		'URL3name': {
			'label': 'Text  3',
			'type': 'text',
			'default': 'Bilder'
		},
			'TabURL4': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL4': {
			'label': 'URL  4',
			'type': 'text',
			'default': 'https://maps.google.com/'
		},
		'URL4name': {
			'label': 'Text  4',
			'type': 'text',
			'default': 'Landkarte'
		},
		'TabURL5': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL5': {
			'label': 'URL  5',
			'type': 'text',
			'default': 'https://play.google.com/'
		},
		'URL5name': {
			'label': 'Text  5',
			'type': 'text',
			'default': 'Spielen'
		},
		'TabURL6': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL6': {
			'label': 'URL  6',
			'type': 'text',
			'default': 'https://www.youtube.com/'
		},
		'URL6name': {
			'label': 'Text  6',
			'type': 'text',
			'default': 'YouTube'
		},
		'TabURL7': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL7': {
			'label': 'URL  7',
			'type': 'text',
			'default': 'https://news.google.com/'
		},
		'URL7name': {
			'label': 'Text  7',
			'type': 'text',
			'default': 'Neu'
		},
		'TabURL8': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL8': {
			'label': 'URL  8',
			'type': 'text',
			'default': 'https://mail.google.com/'
		},
		'URL8name': {
			'label': 'Text  8',
			'type': 'text',
			'default': 'Gmail'
		},
		'TabURL9': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL9': {
			'label': 'URL  9',
			'type': 'text',
			'default': 'https://drive.google.com'
		},
		'URL9name': {
			'label': 'Text  9',
			'type': 'text',
			'default': 'Drive'
		},
		'TabURL10': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL10': {
			'label': 'URL 10',
			'type': 'text',
			'default': 'https://www.google.com/calendar'
		},
		'URL10name': {
			'label': 'Text 10',
			'type': 'text',
			'default': 'Kalender'
		},
		'TabURL11': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL11': {
			'label': 'URL 11',
			'type': 'text',
			'default': 'https://translate.google.com/'
		},
		'URL11name': {
			'label': 'Text 11',
			'type': 'text',
			'default': 'Übersetzen'
		},
		'TabURL12': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL12': {
			'label': 'URL 12',
			'type': 'text',
			'default': ''
		},
		'URL12name': {
			'label': 'Text 12',
			'type': 'text',
			'default': ''
		},
		'TabURL13': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL13': {
			'label': 'URL 13',
			'type': 'text',
			'default': ''
		},
		'URL13name': {
			'label': 'Text 13',
			'type': 'text',
			'default': ''
		},
		'TabURL14': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL14': {
			'label': 'URL 14',
			'type': 'text',
			'default': ''
		},
		'URL14name': {
			'label': 'Text 14',
			'type': 'text',
			'default': ''
		},
		'TabURL15': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL15': {
			'label': 'URL 15',
			'type': 'text',
			'default': ''
		},
		'URL15name': {
			'label': 'Text 15',
			'type': 'text',
			'default': ''
		},
		'TabURL16': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL16': {
			'label': 'URL 16',
			'type': 'text',
			'default': ''
		},
		'URL16name': {
			'label': 'Text 16',
			'type': 'text',
			'default': ''
		},
		'TabURL17': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL17': {
			'label': 'URL 17',
			'type': 'text',
			'default': ''
		},
		'URL17name': {
			'label': 'Text 17',
			'type': 'text',
			'default': ''
		},
		'TabURL18': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL18': {
			'label': 'URL 18',
			'type': 'text',
			'default': ''
		},
		'URL18name': {
			'label': 'Text 18',
			'type': 'text',
			'default': ''
		},
		'TabURL19': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL19': {
			'label': 'URL 19',
			'type': 'text',
			'default': ''
		},
		'URL19name': {
			'label': 'Text 19',
			'type': 'text',
			'default': ''
		},
		'TabURL20': {
			'section':[],
			'label': '',
			'type': 'checkbox',
			'default': false
		},
		'URL20': {
			'label': 'URL 20',
			'type': 'text',
			'default': ''
		},
		'URL20name': {
			'label': 'Text 20',
			'type': 'text',
			'default': ''
	},
  	},
	 'css':'#GM_config_header{background-image:url("data:image/png;base64,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")!important;height:42px!important;background-position:left!important;background-repeat:no-repeat!important;}\
	 #GM_config_buttons_holder{position:absolute!important;right:12px!important;top:5px!important;}\
	 body#GM_config,iframe#GM_config{width:570px!important;}#GM_config .config_var{display: inline-block;}\
	 #GM_config_URL1name_var,#GM_config_URL2name_var,#GM_config_URL3name_var,#GM_config_URL4name_var,#GM_config_URL5name_var,#GM_config_URL6name_var,#GM_config_URL7name_var,#GM_config_URL8name_var,#GM_config_URL9name_var,#GM_config_URL10name_var,#GM_config_URL11name_var,#GM_config_URL12name_var,#GM_config_URL13name_var,#GM_config_URL14name_var,#GM_config_URL15name_var,#GM_config_URL16name_var,#GM_config_URL17name_var,#GM_config_URL18name_var,#GM_config_URL19name_var,#GM_config_URL20name_var{float:right!important;}\
	 #GM_config_resetLink{color:#fff!important;}\ #GM_config_section_header_2,#GM_config_section_header_3{display:none!important;}\#GM_config_section_1,#GM_config_section_2,#GM_config_section_3{display:inline!important;}\
	 #GM_config_section_2,#GM_config_section_3{margin-left:120px!important;}\
	 #GM_config_section_5,#GM_config_section_6,#GM_config_section_7,#GM_config_section_8,#GM_config_section_9,#GM_config_section_10,#GM_config_section_11,#GM_config_section_12,#GM_config_section_13,#GM_config_section_14,#GM_config_section_15,#GM_config_section_16,#GM_config_section_17,#GM_config_section_18,#GM_config_section_19,#GM_config_section_20,#GM_config_section_21,#GM_config_section_22,#GM_config_section_23,#GM_config_section_24,#GM_config_section_25,#GM_config_section_26,#GM_config_section_27,#GM_config_section_28,#GM_config_section_29,#GM_config_section_30,#GM_config_section_31,#GM_config_section_32,#GM_config_section_33,#GM_config_section_34,#GM_config_section_35,#GM_config_section_36,#GM_config_section_37,#GM_config_section_38,#GM_config_section_39,#GM_config_section_40{width:114px!important;display:inline-block!important;margin:0px!important;padding:0px!important;}\
	 #GM_config_section_header_42{background-color:white!important;color:black!important;font-size:9pt!important;border-color:white!important;text-align:left!important;}\
	 #GM_config .config_var{margin:0px!important;}'
});

var GbarLocation = GM_config.get('BarPosition');
var Gbarcolor = GM_config.get('BarColor');
var Gbarlinkcolor = GM_config.get('LinkColor');
var link1 = GM_config.get('URL1');
var name1 = GM_config.get('URL1name');
var link2 = GM_config.get('URL2');
var name2 = GM_config.get('URL2name');
var link3 = GM_config.get('URL3');
var name3 = GM_config.get('URL3name');
var link4 = GM_config.get('URL4');
var name4 = GM_config.get('URL4name');
var link5 = GM_config.get('URL5');
var name5 = GM_config.get('URL5name');
var link6 = GM_config.get('URL6');
var name6 = GM_config.get('URL6name');
var link7 = GM_config.get('URL7');
var name7 = GM_config.get('URL7name');
var link8 = GM_config.get('URL8');
var name8 = GM_config.get('URL8name');
var link9 = GM_config.get('URL9');
var name9 = GM_config.get('URL9name');
var link10 = GM_config.get('URL10');
var name10 = GM_config.get('URL10name');
var link11 = GM_config.get('URL11');
var name11 = GM_config.get('URL11name');
var link12 = GM_config.get('URL12');
var name12 = GM_config.get('URL12name');
var link13 = GM_config.get('URL13');
var name13 = GM_config.get('URL13name');
var link14 = GM_config.get('URL14');
var name14 = GM_config.get('URL14name');
var link15 = GM_config.get('URL15');
var name15 = GM_config.get('URL15name');
var link16 = GM_config.get('URL16');
var name16 = GM_config.get('URL16name');
var link17 = GM_config.get('URL17');
var name17 = GM_config.get('URL17name');
var link18 = GM_config.get('URL18');
var name18 = GM_config.get('URL18name');
var link19 = GM_config.get('URL19');
var name19 = GM_config.get('URL19name');
var link20 = GM_config.get('URL20');
var name20 = GM_config.get('URL20name');
var GoogleBarImage = GM_config.get('GbarImage');
if (GbarLocation == 'Fixed'){
var shadow = 'box-shadow:0px 1px 2px 2px rgba(0,0,0,0.2)!important;}';
var toppx ='0px';
var Gearicon ='6px';
}
if (GbarLocation == 'Absolute'){
var shadow = 'box-shadow: 0px 0px 0px 0px rgba(0,0,0,0.2)!important;}';
var toppx ='-30px';
var toppx2 ='0px';
var Gearicon ='-23px';
var Gearicon2 ='6px';
}
if (GoogleBarImage == 'None') {
	var GoogleBarImage = 'none'
	}
if (GoogleBarImage == 'Glossy' && Gbarcolor == 'Black') {
	var GoogleBarImage = 'url(\'data:image/png;base64,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\')!important'
	}
if (GoogleBarImage == 'Glossy' && Gbarcolor == 'Red') {
	var GoogleBarImage = 'url(\'data:image/png;base64,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\')!important'
	}
if (GoogleBarImage == 'Glossy' && Gbarcolor == 'Red') {
	var GoogleBarImage = 'url(\'data:image/png;base64,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\')!important'
	}
if (GoogleBarImage == 'Glossy' && Gbarcolor == 'Green') {
	var GoogleBarImage = 'url(\'data:image/png;base64,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\')!important'
	}
if (GoogleBarImage == 'Glossy' && Gbarcolor == 'Grey') {
	var GoogleBarImage = 'url(\'data:image/png;base64,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\')!important'
	}
if (GoogleBarImage == 'Glossy' && Gbarcolor == 'Orange') {
	var GoogleBarImage = 'url(\'data:image/png;base64,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\')!important'
	}
if (GoogleBarImage == 'Glossy' && Gbarcolor == 'Yellow') {
	var GoogleBarImage = 'url(\'data:image/png;base64,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\')!important'
	}
if (GoogleBarImage == 'Glossy' && Gbarcolor == 'Blue') {
	var GoogleBarImage = 'url(\'data:image/png;base64,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\')!important'
	}
if (GoogleBarImage == 'Glossy' && Gbarcolor == 'Pink') {
	var GoogleBarImage = 'url(\'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAAeCAYAAADtlXTHAAAACXBIWXMAAAsTAAALEwEAmpwYAAAKT2lDQ1BQaG90b3Nob3AgSUNDIHByb2ZpbGUAAHjanVNnVFPpFj333vRCS4iAlEtvUhUIIFJCi4AUkSYqIQkQSoghodkVUcERRUUEG8igiAOOjoCMFVEsDIoK2AfkIaKOg6OIisr74Xuja9a89+bN/rXXPues852zzwfACAyWSDNRNYAMqUIeEeCDx8TG4eQuQIEKJHAAEAizZCFz/SMBAPh+PDwrIsAHvgABeNMLCADATZvAMByH/w/qQplcAYCEAcB0kThLCIAUAEB6jkKmAEBGAYCdmCZTAKAEAGDLY2LjAFAtAGAnf+bTAICd+Jl7AQBblCEVAaCRACATZYhEAGg7AKzPVopFAFgwABRmS8Q5ANgtADBJV2ZIALC3AMDOEAuyAAgMADBRiIUpAAR7AGDIIyN4AISZABRG8lc88SuuEOcqAAB4mbI8uSQ5RYFbCC1xB1dXLh4ozkkXKxQ2YQJhmkAuwnmZGTKBNA/g88wAAKCRFRHgg/P9eM4Ors7ONo62Dl8t6r8G/yJiYuP+5c+rcEAAAOF0ftH+LC+zGoA7BoBt/qIl7gRoXgugdfeLZrIPQLUAoOnaV/Nw+H48PEWhkLnZ2eXk5NhKxEJbYcpXff5nwl/AV/1s+X48/Pf14L7iJIEyXYFHBPjgwsz0TKUcz5IJhGLc5o9H/LcL//wd0yLESWK5WCoU41EScY5EmozzMqUiiUKSKcUl0v9k4t8s+wM+3zUAsGo+AXuRLahdYwP2SycQWHTA4vcAAPK7b8HUKAgDgGiD4c93/+8//UegJQCAZkmScQAAXkQkLlTKsz/HCAAARKCBKrBBG/TBGCzABhzBBdzBC/xgNoRCJMTCQhBCCmSAHHJgKayCQiiGzbAdKmAv1EAdNMBRaIaTcA4uwlW4Dj1wD/phCJ7BKLyBCQRByAgTYSHaiAFiilgjjggXmYX4IcFIBBKLJCDJiBRRIkuRNUgxUopUIFVIHfI9cgI5h1xGupE7yAAygvyGvEcxlIGyUT3UDLVDuag3GoRGogvQZHQxmo8WoJvQcrQaPYw2oefQq2gP2o8+Q8cwwOgYBzPEbDAuxsNCsTgsCZNjy7EirAyrxhqwVqwDu4n1Y8+xdwQSgUXACTYEd0IgYR5BSFhMWE7YSKggHCQ0EdoJNwkDhFHCJyKTqEu0JroR+cQYYjIxh1hILCPWEo8TLxB7iEPENyQSiUMyJ7mQAkmxpFTSEtJG0m5SI+ksqZs0SBojk8naZGuyBzmULCAryIXkneTD5DPkG+Qh8lsKnWJAcaT4U+IoUspqShnlEOU05QZlmDJBVaOaUt2ooVQRNY9aQq2htlKvUYeoEzR1mjnNgxZJS6WtopXTGmgXaPdpr+h0uhHdlR5Ol9BX0svpR+iX6AP0dwwNhhWDx4hnKBmbGAcYZxl3GK+YTKYZ04sZx1QwNzHrmOeZD5lvVVgqtip8FZHKCpVKlSaVGyovVKmqpqreqgtV81XLVI+pXlN9rkZVM1PjqQnUlqtVqp1Q61MbU2epO6iHqmeob1Q/pH5Z/YkGWcNMw09DpFGgsV/jvMYgC2MZs3gsIWsNq4Z1gTXEJrHN2Xx2KruY/R27iz2qqaE5QzNKM1ezUvOUZj8H45hx+Jx0TgnnKKeX836K3hTvKeIpG6Y0TLkxZVxrqpaXllirSKtRq0frvTau7aedpr1Fu1n7gQ5Bx0onXCdHZ4/OBZ3nU9lT3acKpxZNPTr1ri6qa6UbobtEd79up+6Ynr5egJ5Mb6feeb3n+hx9L/1U/W36p/VHDFgGswwkBtsMzhg8xTVxbzwdL8fb8VFDXcNAQ6VhlWGX4YSRudE8o9VGjUYPjGnGXOMk423GbcajJgYmISZLTepN7ppSTbmmKaY7TDtMx83MzaLN1pk1mz0x1zLnm+eb15vft2BaeFostqi2uGVJsuRaplnutrxuhVo5WaVYVVpds0atna0l1rutu6cRp7lOk06rntZnw7Dxtsm2qbcZsOXYBtuutm22fWFnYhdnt8Wuw+6TvZN9un2N/T0HDYfZDqsdWh1+c7RyFDpWOt6azpzuP33F9JbpL2dYzxDP2DPjthPLKcRpnVOb00dnF2e5c4PziIuJS4LLLpc+Lpsbxt3IveRKdPVxXeF60vWdm7Obwu2o26/uNu5p7ofcn8w0nymeWTNz0MPIQ+BR5dE/C5+VMGvfrH5PQ0+BZ7XnIy9jL5FXrdewt6V3qvdh7xc+9j5yn+M+4zw33jLeWV/MN8C3yLfLT8Nvnl+F30N/I/9k/3r/0QCngCUBZwOJgUGBWwL7+Hp8Ib+OPzrbZfay2e1BjKC5QRVBj4KtguXBrSFoyOyQrSH355jOkc5pDoVQfujW0Adh5mGLw34MJ4WHhVeGP45wiFga0TGXNXfR3ENz30T6RJZE3ptnMU85ry1KNSo+qi5qPNo3ujS6P8YuZlnM1VidWElsSxw5LiquNm5svt/87fOH4p3iC+N7F5gvyF1weaHOwvSFpxapLhIsOpZATIhOOJTwQRAqqBaMJfITdyWOCnnCHcJnIi/RNtGI2ENcKh5O8kgqTXqS7JG8NXkkxTOlLOW5hCepkLxMDUzdmzqeFpp2IG0yPTq9MYOSkZBxQqohTZO2Z+pn5mZ2y6xlhbL+xW6Lty8elQfJa7OQrAVZLQq2QqboVFoo1yoHsmdlV2a/zYnKOZarnivN7cyzytuQN5zvn//tEsIS4ZK2pYZLVy0dWOa9rGo5sjxxedsK4xUFK4ZWBqw8uIq2Km3VT6vtV5eufr0mek1rgV7ByoLBtQFr6wtVCuWFfevc1+1dT1gvWd+1YfqGnRs+FYmKrhTbF5cVf9go3HjlG4dvyr+Z3JS0qavEuWTPZtJm6ebeLZ5bDpaql+aXDm4N2dq0Dd9WtO319kXbL5fNKNu7g7ZDuaO/PLi8ZafJzs07P1SkVPRU+lQ27tLdtWHX+G7R7ht7vPY07NXbW7z3/T7JvttVAVVN1WbVZftJ+7P3P66Jqun4lvttXa1ObXHtxwPSA/0HIw6217nU1R3SPVRSj9Yr60cOxx++/p3vdy0NNg1VjZzG4iNwRHnk6fcJ3/ceDTradox7rOEH0x92HWcdL2pCmvKaRptTmvtbYlu6T8w+0dbq3nr8R9sfD5w0PFl5SvNUyWna6YLTk2fyz4ydlZ19fi753GDborZ752PO32oPb++6EHTh0kX/i+c7vDvOXPK4dPKy2+UTV7hXmq86X23qdOo8/pPTT8e7nLuarrlca7nuer21e2b36RueN87d9L158Rb/1tWeOT3dvfN6b/fF9/XfFt1+cif9zsu72Xcn7q28T7xf9EDtQdlD3YfVP1v+3Njv3H9qwHeg89HcR/cGhYPP/pH1jw9DBY+Zj8uGDYbrnjg+OTniP3L96fynQ89kzyaeF/6i/suuFxYvfvjV69fO0ZjRoZfyl5O/bXyl/erA6xmv28bCxh6+yXgzMV70VvvtwXfcdx3vo98PT+R8IH8o/2j5sfVT0Kf7kxmTk/8EA5jz/GMzLdsAAAAgY0hSTQAAeiUAAICDAAD5/wAAgOkAAHUwAADqYAAAOpgAABdvkl/FRgAAAClJREFUeNpi+H/0/H8mBgYGBrKJ/wwMTAz//zMwMfz7B2NRYh4DAwNgACPTCsT0hVxMAAAAAElFTkSuQmCC\')!important'
	}
if (GoogleBarImage == 'Glossy' && Gbarcolor == 'Purple') {
	var GoogleBarImage = 'url(\'data:image/png;base64,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\')!important'
	}
if (GoogleBarImage == 'Glossy' && Gbarcolor == 'Brown') {
	var GoogleBarImage ='url(\'data:image/png;base64,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\')!important';
	}
if (GoogleBarImage == 'Glossy' && Gbarcolor == 'White') {
	var GoogleBarImage = 'url(\'data:image/png;base64,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\')!important';
	}
if (GoogleBarImage == 'Stary Sky') {
	var GoogleBarImage = 'url(\'data:image/png;base64,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\')!important';
	}
if (GoogleBarImage == 'Ocean') {
	var GoogleBarImage = 'url(\'data:image/png;base64,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\')!important';
	}
if (GoogleBarImage == 'Leaves') {
	var GoogleBarImage = 'url(\'data:image/png;base64,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\')!important';
	}
if (GoogleBarImage == 'nothing') {
	var GoogleBarImage = 'url(\'\')!important';
	}
if (Gbarlinkcolor == 'Grey') {
	var Googlebarlink = 'bbb';
	var Googlebarlinkhover = 'fff';
	}
if (Gbarlinkcolor == 'Black') {
	var Googlebarlink = '000';
	var Googlebarlinkhover = '111';
	}
if (Gbarlinkcolor == 'White') {
	var Googlebarlink = 'fff';
		var Googlebarlinkhover = 'eee';
	}
if (Gbarlinkcolor == 'Red') {
	var Googlebarlink = 'BA0001';
	var Googlebarlinkhover = 'fc4935';
	}
if (Gbarlinkcolor == 'Blue') {
	var Googlebarlink = '6c89cc';
		var Googlebarlinkhover = '437ee5';
	}
if (Gbarlinkcolor == 'Green') {
	var Googlebarlink = '9CFF8A';
	var Googlebarlinkhover = '7ccc6e';
	}
if (Gbarlinkcolor == 'Orange') {
	var Googlebarlink = 'F2C834';
	var Googlebarlinkhover = 'e55c00';
	}
if (Gbarlinkcolor == 'Yellow') {
	var Googlebarlink = 'f2c933';
	var Googlebarlinkhover = 'bf9f28';
	}
if (Gbarlinkcolor == 'Pink') {
	var Googlebarlink = 'FCE0DC';
	var Googlebarlinkhover = 'c9b2af';
	}
if (Gbarlinkcolor == 'Purple') {
	var Googlebarlink = 'D47AFE';
	var Googlebarlinkhover = 'fff';
	}
if (Gbarcolor == 'Transparent') {
	var Googlebarcolor = 'transparent';
	var GooglebarcolorHover = 'transparent';
	var Googlebarbordercolor = 'dd4b39';
}
if (Gbarcolor == 'Grey') {
	var Googlebarcolor = '#2d2d2d';
	var GooglebarcolorHover = '#4b4b4b';
	var Googlebarbordercolor = '#dd4b39';
}
if (Gbarcolor == 'Black') {
	var Googlebarcolor = '#000';
	var GooglebarcolorHover = '#222';
	var Googlebarbordercolor = '#dd4b39';
}
if (Gbarcolor == 'Blue') {
	var Googlebarcolor = '#4584EE';
	var GooglebarcolorHover = '#216ceb';
	var Googlebarbordercolor = '#fff';
}
if (Gbarcolor == 'Green') {
	var Googlebarcolor = '#34960f';
	var GooglebarcolorHover = '#3cad11';
	var Googlebarbordercolor = '#fff';
}
if (Gbarcolor == 'Red') {
	var Googlebarcolor = '#ca3b2b';
	var GooglebarcolorHover = '#d5493a';
	var Googlebarbordercolor = '#fff';
}
if (Gbarcolor == 'Purple') {
	var Googlebarcolor = '#800080';
	var GooglebarcolorHover = '#9a009a';
	var Googlebarbordercolor = '#fff';
}
if (Gbarcolor == 'Orange') {
	var Googlebarcolor = '#ff6500';
	var GooglebarcolorHover = '#ff741a';
	var Googlebarbordercolor = '#fff';
}
if (Gbarcolor == 'Yellow') {
	var Googlebarcolor = '#ffea00';
	var GooglebarcolorHover = '#ffee33';
	var Googlebarbordercolor = '#fff';
}
if (Gbarcolor == 'Pink') {
	var Googlebarcolor = '#ffc0cb';
	var GooglebarcolorHover = '#ffc0cb';
	var Googlebarbordercolor = '#fff';
}
if (Gbarcolor == 'White') {
	var Googlebarcolor = '#fff';
	var GooglebarcolorHover = '#ECF0F8';
	var Googlebarbordercolor = '#1A54E1';
}
if (Gbarcolor == 'Brown') {
	var Googlebarcolor = '#531515';
	var GooglebarcolorHover = '#681a1a';
	var Googlebarbordercolor = '#fff';
}
if (GM_config.get('URL1').length == 0){
	var url1display = 'none';
}
if (GM_config.get('URL1').length < 0){
	var url1display = GbarLocation;
}
if (GM_config.get('URL2').length == 0){
	var url2display = 'none';
}
if (GM_config.get('URL2').length < 0){
	var url2display = GbarLocation;
}
if (GM_config.get('URL3').length == 0){
	var url3display = 'none';
}
if (GM_config.get('URL3').length < 0){
	var url3display = GbarLocation;
}
if (GM_config.get('URL4').length == 0){
	var url4display = 'none';
}
if (GM_config.get('URL4').length < 0){
	var url4display = GbarLocation;
}
if (GM_config.get('URL5').length == 0){
	var url5display = 'none';
}
if (GM_config.get('URL5').length < 0){
	var url5display = GbarLocation;
}
if (GM_config.get('URL6').length == 0){
	var url6display = 'none';
}
if (GM_config.get('URL6').length < 0){
	var url6display = GbarLocation;
}
if (GM_config.get('URL7').length == 0){
	var url7display = 'none';
}
if (GM_config.get('URL7').length < 0){
	var url7display = GbarLocation;
}
if (GM_config.get('URL8').length == 0){
	var url8display = 'none';
}
if (GM_config.get('URL8').length < 0){
	var url8display = GbarLocation;
}
if (GM_config.get('URL9').length == 0){
	var url9display = 'none';
}
if (GM_config.get('URL9').length < 0){
	var url9display = GbarLocation;
}
if (GM_config.get('URL10').length == 0){
	var url10display = 'none';
}
if (GM_config.get('URL10').length < 0){
	var url10display = GbarLocation;
}
if (GM_config.get('URL11').length == 0){
	var url11display = 'none';
}
if (GM_config.get('URL11').length < 0){
	var url11display = GbarLocation;
}
if (GM_config.get('URL12').length == 0){
	var url12display = 'none';
}
if (GM_config.get('URL12').length < 0){
	var url12display = GbarLocation;
}
if (GM_config.get('URL13').length == 0){
	var url13display = 'none';
}
if (GM_config.get('URL13').length < 0){
	var url13display = GbarLocation;
}
if (GM_config.get('URL14').length == 0){
	var url14display = 'none';
}
if (GM_config.get('URL14').length < 0){
	var url14display = GbarLocation;
}
if (GM_config.get('URL15').length == 0){
	var url15display = 'none';
}
if (GM_config.get('URL15').length < 0){
	var url15display = GbarLocation;
}
if (GM_config.get('URL16').length == 0){
	var url16display = 'none';
}
if (GM_config.get('URL16').length < 0){
	var url16display = GbarLocation;
}
if (GM_config.get('URL17').length == 0){
	var url17display = 'none';
}
if (GM_config.get('URL17').length < 0){
	var url17display = GbarLocation;
}
if (GM_config.get('URL18').length == 0){
	var url18display = 'none';
}
if (GM_config.get('URL18').length < 0){
	var url18display = GbarLocation;
}
if (GM_config.get('URL19').length == 0){
	var url19display = 'none';
}
if (GM_config.get('URL19').length < 0){
	var url19display = GbarLocation;
}if (GM_config.get('URL20').length == 0){
	var url20display = 'none';
}
if (GM_config.get('URL20').length < 0){
	var url20display = GbarLocation;
}
if (!(GM_config.get('GbarImage') == 'None')) {
var GooglebarcolorHover = 'rgba(255,255,255,.2)';
}
if (GM_config.get('MenuCheck') == true ){
var Menudisplay ='none';
}
if (GM_config.get('MenuCheck') == false ){
var Menudisplay ='inherit';
}
if (GM_config.get('AlertsCheck') == false ){
var MenuItem1display ='none';
}
if (GM_config.get('AlertsCheck') == true ){
var MenuItem1display ='inherit';
}
if (GM_config.get('BlogSearchCheck') == false ){
var MenuItem2display ='none';
}
if (GM_config.get('BlogSearchCheck') == true ){
var MenuItem2display ='inherit';
}
if (GM_config.get('BloggerCheck') == false ){
var MenuItem3display ='none';
}
if (GM_config.get('BloggerCheck') == true ){
var MenuItem3display ='inherit';
}
if (GM_config.get('BooksCheck') == false ){
var MenuItem4display ='none';
}
if (GM_config.get('BooksCheck') == true ){
var MenuItem4display ='inherit';
}
if (GM_config.get('CalendarCheck') == false ){
var MenuItem5display ='none';
}
if (GM_config.get('CalendarCheck') == true ){
var MenuItem5display ='inherit';
}
if (GM_config.get('CodeCheck') == false ){
var MenuItem6display ='none';
}
if (GM_config.get('CodeCheck') == true ){
var MenuItem6display ='inherit';
}
if (GM_config.get('CustomSearchCheck') == false ){
var MenuItem7display ='none';
}
if (GM_config.get('CustomSearchCheck') == true ){
var MenuItem7display ='inherit';
}
if (GM_config.get('DriveCheck') == false ){
var MenuItem8display ='none';
}
if (GM_config.get('DriveCheck') == true ){
var MenuItem8display ='inherit';
}
if (GM_config.get('EarthCheck') == false ){
var MenuItem9display ='none';
}
if (GM_config.get('EarthCheck') == true ){
var MenuItem9display ='inherit';
}
if (GM_config.get('FinanceCheck') == false ){
var MenuItem10display ='none';
}
if (GM_config.get('FinanceCheck') == true ){
var MenuItem10display ='inherit';
}
if (GM_config.get('FusionTablesCheck') == false ){
var MenuItem11display ='none';
}
if (GM_config.get('FusionTablesCheck') == true ){
var MenuItem11display ='inherit';
}
if (GM_config.get('GmailCheck') == false ){
var MenuItem12display ='none';
}
if (GM_config.get('GmailCheck') == true ){
var MenuItem12display ='inherit';
}
if (GM_config.get('GooglePlusCheck') == false ){
var MenuItem13display ='none';
}
if (GM_config.get('GooglePlusCheck') == true ){
var MenuItem13display ='inherit';
}
if (GM_config.get('GroupsCheck') == false ){
var MenuItem14display ='none';
}
if (GM_config.get('GroupsCheck') == true ){
var MenuItem14display ='inherit';
}
if (GM_config.get('HangoutsCheck') == false ){
var MenuItem15display ='none';
}
if (GM_config.get('HangoutsCheck') == true ){
var MenuItem15display ='inherit';
}
if (GM_config.get('ImageSearch') == false ){
var MenuItem16display ='none';
}
if (GM_config.get('ImageSearch') == true ){
var MenuItem16display ='inherit';
}
if (GM_config.get('MapsCheck') == false ){
var MenuItem17display ='none';
}
if (GM_config.get('MapsCheck') == true ){
var MenuItem17display ='inherit';
}
if (GM_config.get('MobileCheck') == false ){
var MenuItem17_5display ='none';
}
if (GM_config.get('MobileCheck') == true ){
var MenuItem17_5display ='inherit';
}
if (GM_config.get('NewsCheck') == false ){
var MenuItem18display ='none';
}
if (GM_config.get('NewsCheck') == true ){
var MenuItem18display ='inherit';
}
if (GM_config.get('GoogleOffersCheck') == false ){
var MenuItem19display ='none';
}
if (GM_config.get('GoogleOffersCheck') == true ){
var MenuItem19display ='inherit';
}
if (GM_config.get('OrkutCheck') == false ){
var MenuItem20display ='none';
}
if (GM_config.get('OrkutCheck') == true ){
var MenuItem20display ='inherit';
}
if (GM_config.get('PanoramioCheck') == false ){
var MenuItem21display ='none';
}
if (GM_config.get('PanoramioCheck') == true ){
var MenuItem21display ='inherit';
}
if (GM_config.get('PatentSearchCheck') == false ){
var MenuItem22display ='none';
}
if (GM_config.get('PatentSearchCheck') == true ){
var MenuItem22display ='inherit';
}
if (GM_config.get('PhotoCheck') == false ){
var MenuItem22_5display ='none';
}
if (GM_config.get('PhotoCheck') == true ){
var MenuItem22_5display ='inherit';
}
if (GM_config.get('PicasaCheck') == false ){
var MenuItem23display ='none';
}
if (GM_config.get('PicasaCheck') == true ){
var MenuItem23display ='inherit';
}
if (GM_config.get('GooglePlayCheck') == false ){
var MenuItem24display ='none';
}
if (GM_config.get('GooglePlayCheck') == true ){
var MenuItem24display ='inherit';
}
if (GM_config.get('ScholarCheck') == false ){
var MenuItem25display ='none';
}
if (GM_config.get('ScholarCheck') == true ){
var MenuItem25display ='inherit';
}
if (GM_config.get('GoogleShoppingCheck') == false ){
var MenuItem26display ='none';
}
if (GM_config.get('GoogleShoppingCheck') == true ){
var MenuItem26display ='inherit';
}
if (GM_config.get('SitesCheck') == false ){
var MenuItem27display ='none';
}
if (GM_config.get('SitesCheck') == true ){
var MenuItem27display ='inherit';
}
if (GM_config.get('TranslateCheck') == false ){
var MenuItem28display ='none';
}
if (GM_config.get('TranslateCheck') == true ){
var MenuItem28display ='inherit';
}
if (GM_config.get('TrendsCheck') == false ){
var MenuItem29display ='none';
}
if (GM_config.get('TrendsCheck') == true ){
var MenuItem29display ='inherit';
}
if (GM_config.get('VideoSearchCheck') == false ){
var MenuItem30display ='none';
}
if (GM_config.get('VideoSearchCheck') == true ){
var MenuItem30display ='inherit';
}
if (GM_config.get('VoiceCheck') == false ){
var MenuItem31display ='none';
}
if (GM_config.get('VoiceCheck') == true ){
var MenuItem31display ='inherit';
}
if (GM_config.get('GoogleWalletCheck') == false ){
var MenuItem32display ='none';
}
if (GM_config.get('GoogleWalletCheck') == true ){
var MenuItem32display ='inherit';
}
if (GM_config.get('YoutubeCheck') == false ){
var MenuItem33display ='none';
}
if (GM_config.get('YoutubeCheck') == true ){
var MenuItem33display ='inherit';
}
if (GM_config.get('EvenMoreCheck') == false ){
var EvenMoredisplay ='none';
}
if (GM_config.get('EvenMoreCheck') == true ){
var EvenMoredisplay ='inherit';
}
if (GM_config.get('IconDisplay') == "No" ){
var IconDisplayCSS ='#DropDownMenu li {background-image:none!important;}';
}

if (GM_config.get('TabURL1') == true){
	var url1tab = 'target="_blank"';
}
if (GM_config.get('TabURL1') == false){
	var url1tab = '';
}
if (GM_config.get('TabURL2') == true){
	var url2tab = 'target="_blank"';
}
if (GM_config.get('TabURL2') == false){
	var url2tab = '';
}
if (GM_config.get('TabURL3') == true){
	var url3tab = 'target="_blank"';
}
if (GM_config.get('TabURL3') == false){
	var url3tab = '';
}
if (GM_config.get('TabURL4') == true){
	var url4tab = 'target="_blank"';
}
if (GM_config.get('TabURL4') == false){
	var url4tab = '';
}
if (GM_config.get('TabURL5') == true){
	var url5tab = 'target="_blank"';
}
if (GM_config.get('TabURL5') == false){
	var url5tab = '';
}
if (GM_config.get('TabURL6') == true){
	var url6tab = 'target="_blank"';
}
if (GM_config.get('TabURL6') == false){
	var url6tab = '';
}
if (GM_config.get('TabURL7') == true){
	var url7tab = 'target="_blank"';
}
if (GM_config.get('TabURL7') == false){
	var url7tab = '';
}
if (GM_config.get('TabURL8') == true){
	var url8tab = 'target="_blank"';
}
if (GM_config.get('TabURL8') == false){
	var url8tab = '';
}
if (GM_config.get('TabURL9') == true){
	var url9tab = 'target="_blank"';
}
if (GM_config.get('TabURL9') == false){
	var url9tab = '';
}
if (GM_config.get('TabURL10') == true){
	var url10tab = 'target="_blank"';
}
if (GM_config.get('TabURL10') == false){
	var url10tab = '';
}
if (GM_config.get('TabURL11') == true){
	var url11tab = 'target="_blank"';
}
if (GM_config.get('TabURL11') == false){
	var url11tab = '';
}
if (GM_config.get('TabURL12') == true){
	var url12tab = 'target="_blank"';
}
if (GM_config.get('TabURL12') == false){
	var url12tab = '';
}
if (GM_config.get('TabURL13') == true){
	var url13tab = 'target="_blank"';
}
if (GM_config.get('TabURL13') == false){
	var url13tab = '';
}
if (GM_config.get('TabURL14') == true){
	var url14tab = 'target="_blank"';
}
if (GM_config.get('TabURL14') == false){
	var url14tab = '';
}
if (GM_config.get('TabURL15') == true){
	var url15tab = 'target="_blank"';
}
if (GM_config.get('TabURL15') == false){
	var url15tab = '';
}
if (GM_config.get('TabURL16') == true){
	var url16tab = 'target="_blank"';
}
if (GM_config.get('TabURL16') == false){
	var url16tab = '';
}
if (GM_config.get('TabURL17') == true){
	var url17tab = 'target="_blank"';
}
if (GM_config.get('TabURL17') == false){
	var url17tab = '';
}
if (GM_config.get('TabURL18') == true){
	var url18tab = 'target="_blank"';
}
if (GM_config.get('TabURL18') == false){
	var url18tab = '';
}
if (GM_config.get('TabURL19') == true){
	var url19tab = 'target="_blank"';
}
if (GM_config.get('TabURL19') == false){
	var url19tab = '';
}
if (GM_config.get('TabURL20') == true){
	var url20tab = 'target="_blank"';
}
if (GM_config.get('TabURL20') == false){
	var url20tab = '';
}
if (GM_config.get('Youtubeshow') == "Yes" ){
var youtubestyle = ".site-left-aligned #yt-masthead-container, .site-left-aligned #masthead-appbar, .site-left-aligned #footer-container, #ticker, body #sb-wrapper"}
if (GM_config.get('Youtubeshow') == "No" ){
var youtubestyle = ".nothing33"}
var alerticon="data:image/png;base64,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"

var bloggericon="data:image/png;base64,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"

var blogsearchicon="data:image/png;base64,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"

var bookicon="data:image/png;base64,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"

var calendaricon = "data:image/png;base64,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"

var codeicon ="data:image/png;base64,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"

var customsearchicon ="data:image/png;base64,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"

var driveicon="data:image/png;base64,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"

var earthicon ="data:image/png;base64,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"

var financeicon ="data:image/png;base64,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"

var fusiontablesicon = "data:image/png;base64,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"

var gmailicon ="data:image/png;base64,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"

var googleplusicon ="data:image/png;base64,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"

var groupsicon = "data:image/png;base64,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"

var hangoutsicon = "data:image/png;base64,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"

var imagesearchicon = "data:image/png;base64,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"

var mapsicon = "data:image/png;base64,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"

var mobileicon = "data:image/png;base64,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"

var newsicon = "data:image/png;base64,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"

var offersicon = "data:image/png;base64,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"

var orkuticon = "data:image/png;base64,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"

var panaramioicon = "data:image/png;base64,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"

var patentsearchicon = "data:image/png;base64,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"

var photoicon = "data:image/png;base64,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"

var picasaicon = "data:image/png;base64,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"

var playicon = "data:image/png;base64,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"

var scholaricon = "data:image/png;base64,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"

var shoppingicon = "data:image/png;base64,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"

var sitesicon = "data:image/png;base64,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"

var translateicon = "data:image/png;base64,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"

var trendsicon = "data:image/png;base64,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"

var videoicon = "data:image/png;base64,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"

var voiceicon = "data:image/png;base64,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"

var walleticon = "data:image/png;base64,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"

var youtubeicon = "data:image/png;base64,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"

var divBlackBar = '<div class="Black_Nav_Bar">'
+ '<ul id=GNav>'
+ '<li class="bar"><a id="url1" href="' + link1 + '"'+url1tab+'>' + name1 + '</a></li>'
+ '<li class="bar"><a id="url2" href="' + link2 + '"'+url2tab+'>' + name2 + '</a></li>'
+ '<li class="bar"><a id="url3" href="' + link3 + '"'+url3tab+'>' + name3 + '</a></li>'
+ '<li class="bar"><a id="url4" href="' + link4 + '"'+url4tab+'>' + name4 + '</a></li>'
+ '<li class="bar"><a id="url5" href="' + link5 + '"'+url5tab+'>' + name5 + '</a></li>'
+ '<li class="bar"><a id="url6" href="' + link6 + '"'+url6tab+'>' + name6 + '</a></li>'
+ '<li class="bar"><a id="url7" href="' + link7 + '"'+url7tab+'>' + name7 + '</a></li>'
+ '<li class="bar"><a id="url8" href="' + link8 + '"'+url8tab+'>' + name8 + '</a></li>'
+ '<li class="bar"><a id="url9" href="' + link9 + '"'+url9tab+'>' + name9 + '</a></li>'
+ '<li class="bar"><a id="url10" href="'+ link10+ '"'+url10tab+'>' + name10 + '</a></li>'
+ '<li class="bar"><a id="url11" href="'+ link11+ '"'+url11tab+'>' + name11 + '</a></li>'
+ '<li class="bar"><a id="url12" href="'+ link12+ '"'+url12tab+'>' + name12 + '</a></li>'
+ '<li class="bar"><a id="url13" href="'+ link13+ '"'+url13tab+'>' + name13 + '</a></li>'
+ '<li class="bar"><a id="url14" href="'+ link14+ '"'+url14tab+'>' + name14 + '</a></li>'
+ '<li class="bar"><a id="url15" href="'+ link15+ '"'+url15tab+'>' + name15 + '</a></li>'
+ '<li class="bar"><a id="url16" href="'+ link16+ '"'+url16tab+'>' + name16 + '</a></li>'
+ '<li class="bar"><a id="url17" href="'+ link17+ '"'+url17tab+'>' + name17 + '</a></li>'
+ '<li class="bar"><a id="url18" href="'+ link18+ '"'+url18tab+'>' + name18 + '</a></li>'
+ '<li class="bar"><a id="url19" href="'+ link19+ '"'+url19tab+'>' + name19 + '</a></li>'
+ '<li class="bar"><a id="url20" href="'+ link20+ '"'+url20tab+'>' + name20 + '</a></li>'
+ '<li id="MoreDrop">'
+'<a id="More" href="javascript:void(0)">More</a>'
+ '<ul id="DropDownMenu">'
+ '<li id=MenuItem1><a id="DropDown1" href="https://www.google.com/alerts/">Alerts</a></li>'
+' <li id=MenuItem2><a id="DropDown2" href="https://www.google.com/blogsearch/">Blog Search</a></li>'
+' <li id=MenuItem3><a id="DropDown3" href="https://www.blogger.com/">Blogger</a></li>'
+' <li id=MenuItem4><a id="DropDown4" href="https://books.google.com/">Books</a></li>'
+' <li id=MenuItem5><a id="DropDown5" href="https://www.google.com/calendar/">Calendar</a></li>'
+' <li id=MenuItem6><a id="DropDown6" href="https://code.google.com/">Code</a></li>'
+' <li id=MenuItem7><a id="DropDown7" href="https://www.google.com/cse/">Custom Search</a></li>'
+' <li id=MenuItem8><a id="DropDown8" href="https://drive.google.com/">Drive</a></li>'
+' <li id=MenuItem9><a id="DropDown9" href="https://www.google.com/earth/">Earth</a></li>'
+' <li id=MenuItem10><a id="DropDown10" href="https://www.google.com/finance/">Finance</a></li>'
+ '<li id=MenuItem11><a id="DropDown11" href="https://www.google.com/fusiontables/">Fusion Tables</a></li>'
+' <li id=MenuItem12><a id="DropDown12" href="https://mail.google.com/">Gmail</a></li>'
+' <li id=MenuItem13><a id="DropDown13" href="https://plus.google.com/">Google+</a></li>'
+' <li id=MenuItem14><a id="DropDown14" href="https://groups.google.com/">Groups</a></li>'
+' <li id=MenuItem15><a id="DropDown15" href="http://www.google.com/hangouts/">Hangouts</a></li>'
+' <li id=MenuItem16><a id="DropDown16" href="http://www.google.com/imghp">Image Search</a></li>'
+' <li id=MenuItem17><a id="DropDown17" href="https://maps.google.com/">Maps</a></li>'
+' <li id=MenuItem17_5><a id="DropDown17_5" href="https://www.google.com/mobile/">Mobile</a></li>'
+ '<li id=MenuItem18><a id="DropDown18" href="https://news.google.com/">News</a></li>'
+' <li id=MenuItem19><a id="DropDown19" href="https://www.google.com/offers">Offers</a></li>'
+' <li id=MenuItem20><a id="DropDown20" href="https://www.orkut.com/">Orkut</a></li>'
+' <li id=MenuItem21><a id="DropDown21" href="http://www.panoramio.com/">Panoramio</a></li>'
+' <li id=MenuItem22><a id="DropDown22" href="https://www.google.com/?tbm=pts">Patent Search</a></li>'
+' <li id=MenuItem22_5><a id="DropDown22" href="https://www.google.com/+/photos">Photo</a></li>'
+' <li id=MenuItem23><a id="DropDown23" href="http://picasa.google.com/">Picasa</a></li>'
+' <li id=MenuItem24><a id="DropDown24" href="https://play.google.com/">Play</a></li>'
+' <li id=MenuItem25><a id="DropDown25" href="https://scholar.google.com/">Scholar</a></li>'
+' <li id=MenuItem26><a id="DropDown26" href="https://www.google.com/shopping">Shopping</a></li>'
+' <li id=MenuItem27><a id="DropDown27" href="https://sites.google.com/">Sites</a></li>'
+' <li id=MenuItem28><a id="DropDown28" href="https://translate.google.com/">Translate</a></li>'
+' <li id=MenuItem29><a id="DropDown29" href="https://www.google.com/trends/">Trends</a></li>'
+' <li id=MenuItem30><a id="DropDown30" href="https://www.google.com/videohp">Video</a></li>'
+' <li id=MenuItem31><a id="DropDown31" href="https://www.google.com/voice">Voice</a></li>'
+' <li id=MenuItem32><a id="DropDown32" href="https://www.google.com/wallet/">Wallet</a></li>'
+' <li id=MenuItem33><a id="DropDown33" href="https://www.youtube.com/">YouTube</a></li>'
+' <li id=EvenMore><a id="EvenMoreLink" href="https://www.google.com/intl/en/about/products/">Even More</a></li>'
+ '</ul>'
+ '</li>'
+ '</ul>'
+'<img id="gearicon" src="data:image/png;base64,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"</img>';


var GoogleBarstyle = '' + '.Black_Nav_Bar {;z-index:999999!important;background-color:' + Googlebarcolor + '; position:' + GbarLocation + ';top:0; left:0px; width:100%; height:30px;background-image:'+GoogleBarImage+';}' + '.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {font: 13px Arial,sans-serif;position:relative; top:5px;color:#' + Googlebarlink + '; padding:5px 10px 6px 10px; text-decoration:none; font-weight:bold; border-top:transparent 2px solid;}' + '.Black_Nav_Bar a:hover{color:#' + Googlebarlinkhover + ';background-color:' + GooglebarcolorHover + ' ;border-top-color:#' + Googlebarbordercolor + '!important;}'+'#More:after{font-size: 8px; content: \" ▼\";};'

var style = '' + '.gb_i.gb_j,[title=Apps],[src="http://1a7x.com/126357"],[onload="bodyLoaded()"] > .Black_Nav_Bar,.Dw > .Black_Nav_Bar,.Vzc.Mb > .Black_Nav_Bar,.o-ZLb-El-LEc  > .Black_Nav_Bar,div.gb_o ul.gb_q,div.gb_o a.gb_r,[onload="bodyLoaded()"] > #gearicon,.Vzc.Mb > #gearicon,.o-ZLb-El-LEc  > #gearicon,div#gbwa.gb_m div.gb_o{display:none!important;}'
+'.aAU.Black_Nav_Bar{display:block!important;}'
+'#gearicon{opacity:0.4!important;}'
+'#gearicon:hover{opacity:1!important;}'
+'#url1{margin-left:34px!important;}'
+'#GNav div{display:none!important;}'
+'.Black_Nav_Bar{'+ shadow +'}'
+'a#url1{display: '+ url1display +'!important;}'
+'a#url2{display: '+ url2display +'!important;}'
+'a#url3{display: '+ url3display +'!important;}'
+'a#url4{display: '+ url4display +'!important;}'
+'a#url5{display: '+ url5display +'!important;}'
+'a#url6{display: '+ url6display +'!important;}'
+'a#url7{display: '+ url7display +'!important;}'
+'a#url8{display: '+ url8display +'!important;}'
+'a#url9{display: '+ url9display +'!important;}'
+'a#url10{display: '+ url10display +'!important;}'
+'a#url11{display: '+ url11display +'!important;}'
+'a#url12{display: '+ url12display +'!important;}'
+'a#url13{display: '+ url13display +'!important;}'
+'a#url14{display: '+ url14display +'!important;}'
+'a#url15{display: '+ url15display +'!important;}'
+'a#url16{display: '+ url16display +'!important;}'
+'a#url17{display: '+ url17display +'!important;}'
+'a#url18{display: '+ url18display +'!important;}'
+'a#url19{display: '+ url19display +'!important;}'
+'a#url20{display: '+ url20display +'!important;}'
+'#MoreDrop{display: '+ Menudisplay +'!important;}'
//alets
+'#MenuItem1{display: '+ MenuItem1display +'!important;background-image:url("'+alerticon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//blog search
+'#MenuItem2{display: '+ MenuItem2display +'!important;background-image:url("'+blogsearchicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//blogger
+'#MenuItem3{display: '+ MenuItem3display +'!important;background-image:url("'+bloggericon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//books
+'#MenuItem4{display: '+ MenuItem4display +'!important;background-image:url("'+bookicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//calendar
+'#MenuItem5{display: '+ MenuItem5display +'!important;background-image:url("'+calendaricon+'");background-repeat:no-repeat;background-position:5px 6px!important;}'
//code
+'#MenuItem6{display: '+ MenuItem6display +'!important;background-image:url("'+codeicon+'");background-repeat:no-repeat;background-position:5px 7px!important;}'
//custom search
+'#MenuItem7{display: '+ MenuItem7display +'!important;background-image:url("'+customsearchicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//drive
+'#MenuItem8{display: '+ MenuItem8display +'!important;background-image:url("'+driveicon+'");background-repeat:no-repeat;background-position:5px 6px!important;}'
//earth
+'#MenuItem9{display: '+ MenuItem9display +'!important;background-image:url("'+earthicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//finance
+'#MenuItem10{display: '+ MenuItem10display +'!important;background-image:url("'+financeicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//fustion tables
+'#MenuItem11{display: '+ MenuItem11display +'!important;background-image:url("'+fusiontablesicon+'");background-repeat:no-repeat;background-position:6px 5px!important;}'
//gmail
+'#MenuItem12{display: '+ MenuItem12display +'!important;background-image:url("'+gmailicon+'");background-repeat:no-repeat;background-position:5px 8px!important;}'
//google+
+'#MenuItem13{display: '+ MenuItem13display +'!important;background-image:url("'+googleplusicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//groups
+'#MenuItem14{display: '+ MenuItem14display +'!important;background-image:url("'+groupsicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//hangouts
+'#MenuItem15{display: '+ MenuItem15display +'!important;background-image:url("'+hangoutsicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//image search
+'#MenuItem16{display: '+ MenuItem16display +'!important;background-image:url("'+imagesearchicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//maps
+'#MenuItem17{display: '+ MenuItem17display +'!important;background-image:url("'+mapsicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//mobile
+'#MenuItem17_5{display: '+ MenuItem17_5display +'!important;background-image:url("'+mobileicon+'");background-repeat:no-repeat;background-position:8px 5px!important;}'
//news
+'#MenuItem18{display: '+ MenuItem18display +'!important;background-image:url("'+newsicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//offers
+'#MenuItem19{display: '+ MenuItem19display +'!important;background-image:url("'+offersicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//orkut
+'#MenuItem20{display: '+ MenuItem20display +'!important;background-image:url("'+orkuticon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//panaramio
+'#MenuItem21{display: '+ MenuItem21display +'!important;background-image:url("'+panaramioicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//patent search
+'#MenuItem22{display: '+ MenuItem22display +'!important;background-image:url("'+patentsearchicon+'");background-repeat:no-repeat;background-position:7px 5px!important;}'
//photo
+'#MenuItem22_5{display: '+ MenuItem22_5display +'!important;background-image:url("'+photoicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//picasa
+'#MenuItem23{display: '+ MenuItem23display +'!important;background-image:url("'+picasaicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//play
+'#MenuItem24{display: '+ MenuItem24display +'!important;background-image:url("'+playicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//scholar
+'#MenuItem25{display: '+ MenuItem25display +'!important;background-image:url("'+scholaricon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//shopping
+'#MenuItem26{display: '+ MenuItem26display +'!important;background-image:url("'+shoppingicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//sites
+'#MenuItem27{display: '+ MenuItem27display +'!important;background-image:url("'+sitesicon+'");background-repeat:no-repeat;background-position:6px 5px!important;}'
//translate
+'#MenuItem28{display: '+ MenuItem28display +'!important;background-image:url("'+translateicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//trends
+'#MenuItem29{display: '+ MenuItem29display +'!important;background-image:url("'+trendsicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//video
+'#MenuItem30{display: '+ MenuItem30display +'!important;background-image:url("'+videoicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//voice
+'#MenuItem31{display: '+ MenuItem31display +'!important;background-image:url("'+voiceicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//wallet
+'#MenuItem32{display: '+ MenuItem32display +'!important;background-image:url("'+walleticon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
//youtube
+'#MenuItem33{display: '+ MenuItem33display +'!important;background-image:url("'+youtubeicon+'");background-repeat:no-repeat;background-position:5px 5px!important;}'
+'#EvenMore{display: '+ EvenMoredisplay +'!important;}'
+'#EvenMore{border-top: 1px solid rgb(190, 190, 190);}'
+'#DropDownMenu{display: none;height:auto;position: absolute;z-index: 999;top:29px;padding:0px;margin:0px;background: none repeat scroll 0% 0% rgb(255, 255, 255);box-shadow: 0px 2px 4px rgba(0, 0, 0, 0.2);list-style:none;}'
+'#DropDownMenu a{top:0px!important;padding:3px 30px!important;color: rgb(51, 102, 204) !important;width:150px!important;}'
+'#DropDownMenu a:hover{background-color:transparent!important;border-color:transparent!important;}'
+''+IconDisplayCSS+''
+'#DropDownMenu li:hover{color: rgb(51, 102, 204) !important;background-color:rgb(238, 238, 238)!important;border-color:rgb(238, 238, 238)!important;}'
+'#MoreDrop:Hover #DropDownMenu{display:block!important;}'
+'#GNav {	width: 100%;	float: left;	margin: 0 0 3em 0;	padding: 0;	list-style: none; }'
+'#GNav li {float: left; }'
+'#DropDownMenu li{clear:both!important;padding:6px 0px!important;width:157px!important;}'
+'iframe > html > body > .Black_Nav_Bar{display:none!important;}'
+'.gb_bb{top:0px!important;}'
+'.JW,.TJb,#ID-report,#ID-reportHeader,'+youtubestyle+'{margin-top:30px!important;}'
+'#mh{margin-top:40px!important;}'
+'.hp #esp-gbc{padding-top:45px!important;}'
//+'#gbx3,.gbzt .gbts,#gbztms,#gbx4,#gbg,.gbzt{opacity:0!important;}'
//options
+'iframe#GM_config{width:595px!important;box-shadow: 0 4px 16px rgba(0, 0, 0, 0.5)!important;border: 1px solid rgba(0, 0, 0, 0.333)!important;position:Fixed!important;left: calc(100% - 600px)!important;top:40px!important;}'
+'#gearicon{width:16px!important;height:16px!important;position:'+ GbarLocation +'!important;z-index:9999999!important;right:4px!important;top:6px!important;}';
$('head').append('<style>' + style + '</style>');
if( window.self === window.top ) {
//google
$(function () {
	if (document.location.href.indexOf('www.google.') > -1) {
		var style = ''+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}'
		+'html{overflow:auto!important;}'
		+'body{overflow:visible!important; position:relative!important; top:30px!important;height:calc(100% - 30px)!important;}'
		+'.Black_Nav_Bar{top:'+toppx+'!important;}';
		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});
//more
$(function () {
	if (document.location.href.indexOf('/products') > -1) {
		var style = ''+'.Black_Nav_Bar{width:calc(100% + 30px)!important;left:-15px!important;}';
		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});
//Bookmarks
$(function () {
	if (document.location.href.indexOf('/bookmarks') > -1) {
		var style = ''+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}'
		+'body{position:static!important;}'
		+'#gbx1, #gbq {top:0px!important;}'
		+'#gb {top:30px!important;}'
		+'#gba {height:90px!important;}'
		+'.Black_Nav_Bar{top:0px!important;}';
		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
//		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});
//YouTube
if (GM_config.get('Youtubeshow') == "Yes" ){
$(function () {
	if (document.location.href.indexOf('www.youtube.') > -1) {
		var style = ''+ 'body{padding-top:30px!important;}'
		+ '.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}'
		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});
}



});
}
//Google Play
$(function () {
	if (document.location.href.indexOf('play.google') > -1) {
		var style = ''+'html{overflow:auto!important;}'
		+'body{overflow:visible!important; position:relative!important; top:30px!important;height:calc(100% - 30px)!important;}'
		+'.Black_Nav_Bar{top:'+toppx+'!important;}'
		+ '.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:6px!important;}';
		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});
//Books
$(function () {
	if (document.location.href.indexOf('books.google') > -1) {

		var style = ''+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}'
		+'body{position:static!important;}'
		+'#gbx1, #gbq {top:30px!important;}'
		+'.Black_Nav_Bar{top:0px!important;}';
		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});
//Images Search
$(function () {
	if (document.location.href.indexOf('imghp') > -1) {
		var style = '' + '.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});
$(function () {
	if (document.location.href.indexOf('site=imghp') > -1) {
		var style = '' + '.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});
$(function () {
	if (document.location.href.indexOf('images.google') > -1) {
		var style = ''+'html{overflow:auto!important;}'
		+'body{overflow:visible!important; position:relative!important; top:30px!important;height:calc(100% - 30px)!important;}'
		+'.Black_Nav_Bar{top:'+toppx+'!important;}'
		+ '.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}';
		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});
//News
$(function () {
	if (document.location.href.indexOf('news.google') > -1) {
		var style = ''+'html{overflow:auto!important;}'
		+'body{overflow:visible!important; position:relative!important; top:30px!important;height:calc(100% - 30px)!important;}'
		+'.Black_Nav_Bar{top:'+toppx+'!important;}'
		+ '.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:6px!important;}';
		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});
//Video Search
$(function () {
	if (document.location.href.indexOf('/videohp') > -1) {
		var style = ''+ '.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}'
		+'body{overflow:visible!important; position:relative!important; top:0px!important;height:100%!important;}'
		+'.Black_Nav_Bar{top:0px!important;}'
		+'#gb{top:30px!important;}';//gb_bb
		$('head').append('<style>' + style + '</style>');
	}
});
//Picasa
$(function () {
	if (document.location.href.indexOf('picasaweb.google') > -1) {
		var style = ''+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}';
		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});
//Google Offers
$(function () {
	if (document.location.href.indexOf('/offers') > -1) {
		var style = '' + '.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});
//Maps
$(function () {
	if (document.location.href.indexOf('/maps') > -1) {
		var style = '' +'.bar{height:16px!important;background-color:transparent!important;}'
		+'html,#main,#inner,#main_map,#map,#ds-v .ds,#spsizer > div:nth-child(5){height: 100%!important;}'
		+'#page{height:calc(100% - 62px)!important;}'
		+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:5px!important;}'
		+'html{overflow:auto!important;}'
		+'#page > div:nth-child(6){height: 100%!important;position: absolute!important;top: 0px!important;}'
		+'#panel{height: calc(100% - 58px)!important;overflow: auto!important;}'
		+'.small #panel{height: calc(100% - 44px)!important;}'
		+'#spsizer {overflow: visible!important;height: 100%!important;}'
		+'#opanel6{position: absolute!important;min-height: 100%!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});
$(function () {
	if (document.location.href.indexOf('maps.google.') > -1) {
		var style = ''+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:5px!important;}'
		+'html{overflow:auto!important;}'
		+'body{overflow:visible!important; position:relative!important; top:30px!important;height:calc(100% - 30px)!important;}'
		+'.Black_Nav_Bar{top:'+toppx+'!important;}'
		+'.bar{height:16px!important;background-color:transparent!important;}'
		+'html,#main,#inner,#main_map,#map,#ds-v .ds,#spsizer > div:nth-child(5){height: 100%!important;}'
		+'#page{height:calc(100% - 62px)!important;}'
		+'#page > div:nth-child(6){height: 100%!important;position: absolute!important;top: 0px!important;}'
		+'#panel{height: calc(100% - 58px)!important;overflow: auto!important;}'
		+'.small #panel{height: calc(100% - 44px)!important;}'
		+'#spsizer {overflow: visible!important;height: 100%!important;}'
		+'#opanel6{position: absolute!important;min-height: 100%!important;}';
		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});
//blogsearch
$(function () {
	if (document.location.href.indexOf('/blogsearch') > -1) {
		var style = ''+ '.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:6px!important;}'
		+'body{position:static!important;height:100%!important;}'
		+'#gb{padding-bottom: 30px!important;}'
		+'.Black_Nav_Bar{top:0px!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});
//Custom Search
$(function () {
	if (document.location.href.indexOf('/cse') > -1) {
		var style = ''+'.Black_Nav_Bar{width:calc(100% + 30px)!important;left:-15px!important;}';
		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});
//Patent Search
$(function () {
	if (document.location.href.indexOf('/?tbm=') > -1) {
		var style = ''+'body{position:static!important;height:100%!important;}'
		+'.Black_Nav_Bar{top:0px!important;}'

		+'#gb{margin-top:30px!important;}';

		$('head').append('<style>' + style + '</style>');
	}
});
$(function () {
	if (document.location.href.indexOf('/patents') > -1) {
		var style = ''+'body{position:static!important;height:100%!important;}'
		+'.Black_Nav_Bar{top:0px!important;}'
		+'#gbx1, #gbq {top:30px!important;}'

		+ '.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});
//Google Shopping
$(function () {
	if (document.location.href.indexOf('/shopping') > -1) {
		var style = ''+'body{position:static!important;height:100%!important;}'
		+'.Black_Nav_Bar{top:0px!important;}'

		+'#gbx1, #gbq {top:0px!important;}'

		+'#gb{top:20px!important;}'

		+ '.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:5px!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});
//finance
$(function () {
	if (document.location.href.indexOf('/finance') > -1) {

		var style = ''+ 'body {top: 0px!important;height:100%!important;}'
		+ '.Black_Nav_Bar {top:'+toppx2+'!important;}'
		+'#gearicon{top:'+Gearicon2+'!important;}'
		+'#gb #gbx1.gbes, #gb #gbx2.gbes, #gb.gbesi #gbx1, #gb.gbesi #gbx2, #gb #gbq.gbes, #gb #gbu.gbes, #gb.gbesi #gbq, #gb.gbesi #gbu {top: 30px!important;}'

		+'#gb{top:30px!important;}'

		+'#gba{padding-bottom:30px}!important;}'

		+'#gb .gbes{height: 76px!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});
//Scholar
$(function () {
	if (document.location.href.indexOf('scholar.google.') > -1) {
		var style = ''+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}'
		+'html{overflow:auto!important;}'
		+'body{overflow:visible!important; position:relative!important; top:0px!important;height:100%!important;}'
		+'.Black_Nav_Bar{top:0px!important;}';
		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});
//alerts
$(function () {
	if (document.location.href.indexOf('/alerts') > -1) {

		var style = ''+ '.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}'
		+'body{position:static!important;}'
		+'#gbx1, #gbq {top:30px!important;}'

		+'#gb-main{top:30px!important;}'

		+'.Black_Nav_Bar{top:0px!important;}';
		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
//		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});
//gmail
$(function () {
	if (document.location.href.indexOf('mail.google') > -1) {

		var style = ''+ '.no{margin-top:15px!important;}'
		+'.AD{bottom:30px!important;}'
		+'#gb{margin-top:30px!important;}'
		+ '.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:4px!important;}'

        +'.aLF-aPX {top: 30px !important;}';/* *** */

		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

		$('[g_editable="true"] > .Black_Nav_Bar').remove();
		$('[g_editable="true"] > #gearicon').remove();


	}
});
//drive
$(function () {
	if (document.location.href.indexOf('drive.google') > -1) {
		var style = '' +'html{overflow:auto!important;}'
		+'body{overflow:visible!important; position:relative!important; top:30px!important;height:calc(100% - 30px)!important;}'
		+'.Black_Nav_Bar{top:'+toppx+'!important;}'
		+ '.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}';
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('head').append('<style>' + style + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});
//Sites
$(function () {
	if (document.location.href.indexOf('sites.google.') > -1) {
		var style = ''+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}'
		+'html{overflow:auto!important;}'
		+'body{overflow:visible!important; position:relative!important; top:30px!important;height:calc(100% - 30px)!important;}'
		+'.Black_Nav_Bar{top:'+toppx+'!important;}';
		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});
//calendar
$(function () {
	if (document.location.href.indexOf('/calendar') > -1) {
		var style = ''+'html {overflow:hidden!important;}'
		+'body {position:static!important;}'
		+'.Black_Nav_Bar {top:0px!important;}'
		+'#gb {margin-top:30px!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});
//translate
$(function () {
	if (document.location.href.indexOf('translate.google') > -1) {

		var style = '' +'html{overflow:auto!important;}'
		+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}'
		+'body{overflow:visible!important; position:absolute!important; top:30px!important;height:calc(100% - 30px)!important;width:100%!important;}'
		+'.Black_Nav_Bar{top:'+toppx+'!important;}';
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('head').append('<style>' + style + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});
//voice
$(function () {
	if (document.location.href.indexOf('/voice') > -1) {
		var style = '' +'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}'
		+'body{position:static!important;}'
		+'#gbx1, #gbq {top:30px!important;}'
		+'.Black_Nav_Bar{top:0px!important;}'
		+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:5px!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});
//Google Cloud Print
$(function () {
	if (document.location.href.indexOf('/cloudprint') > -1) {
		var style = ''+ '.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});
//Google Keep
$(function () {
	if (document.location.href.indexOf('/keep') > -1) {
		var style = ''+ '.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:2px!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});
$(function () {
	if (document.location.href.indexOf('keep.google') > -1) {
		var style = '' +'html{overflow:auto!important;}'
		+'body{overflow:visible!important; position:relative!important; top:30px!important;height:calc(100% - 30px)!important;}'
		+'.Black_Nav_Bar{top:'+toppx+'!important;}'
		+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}';
		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});


//Google+
$(function () {
	if (document.location.href.indexOf('plus.google') > -1) {
        if (GbarLocation == 'Absolute'){
			var style = ''+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}'
            +'[style="top: 104px;"]{top: 134px!important;}'
            +'[style="top: 60px;"]{top: 90px!important;}'
            +'.Of[style="top: 0px;"]{margin-top: 30px!important;}'
            +'.Z0{top:30px!important;}';
        }
        if (GbarLocation == 'Fixed'){
            var style = ''+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}'
            +'.Black_Nav_Bar{box-shadow: 0px 0px 0px 0px rgba(0,0,0,0.2)!important;}'
            +'[style="top: 104px;"]{top: 134px!important;}'
            +'[style="top: 60px;"]{top: 90px!important;}'
            +'[style="top: 44px;"]{top: 74px!important;}'
            +'[style="top: 0px;"]{top: 30px!important;}'
            +'[style="top: -60px;"]{top: -30px!important;}'
            +'.Z0{top:30px!important;}';
        }
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('head').append('<style>' + style + '</style>');
		$('body.Td').prepend(divBlackBar);
	}
});
//Groups
$(function () {
	if (document.location.href.indexOf('groups.google') > -1) {
		var style = '' +'html{overflow:auto!important;}'
		+'body{overflow:visible!important; position:relative!important; top:30px!important;height:calc(100% - 30px)!important;}'
		+'.Black_Nav_Bar{top:'+toppx+'!important;}'
		+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}';
		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});
//productforums
$(function () {
	if (document.location.href.indexOf('productforums.google') > -1) {
		var style = '' +'html{overflow:auto!important;}'
		+'body{overflow:visible!important; position:relative!important; top:30px!important;height:calc(100% - 30px)!important;}'
		+'.Black_Nav_Bar{top:'+toppx+'!important;}'
		+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:7px!important;}';
		$('head').append('<style>' + style + '</style>');
		$('head').append('<style>' + GoogleBarstyle + '</style>');
		$('body').prepend(divBlackBar);
$( "#gearicon" ).click(function() {
	GM_config.open();
});

	}
});
//analytics
$(function () {
	if (document.location.href.indexOf('/analytics/') > -1) {
		var style = ''+'.Black_Nav_Bar{width:calc(100% + 30px)!important;left:-15px!important;}'

		+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:4px!important;}';

		$('head').append('<style>' + style + '</style>');



	}
});
//Inside Search
$(function () {
	if (document.location.href.indexOf('/search/about/') > -1) {
		var style = ''+'html{padding:0px!important;}'

		+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:4px!important;}';

		$('head').append('<style>' + style + '</style>');



	}
});
//could not test left original coding in place, and added code removed from var style
//music
$(function () {
	if (document.location.href.indexOf('/music/') > -1) {
		var style = ''+ '#content-container,#nav-container{margin-top:30px!important;}'
		+'#player{bottom:-30px!important;}'
		+'#gb{margin-top:30px!important;}'
        +'.gb_bb{top:0px!important;}'
        +'.JW,.TJb,#ID-report,#ID-reportHeader,'+youtubestyle+'{margin-top:30px!important;}'
        +'#mh{margin-top:40px!important;}'
        +'.hp #esp-gbc{padding-top:45px!important;}'
        +'#gbx3,.gbzt .gbts,#gbztms,#gbx4,#gbg,.gbzt{opacity:0!important;}';
		$('head').append('<style>' + style + '</style>');



	}
});
//wallet
$(function () {
	if (document.location.href.indexOf('/wallet') > -1) {
		var style = ''+'#maia-header, #maia-nav-x, #maia-footer, .maia-stage{margin-top:30px!important;}'
		+'.Black_Nav_Bar a,.Black_Nav_Bar a:visited  {top:5px!important;}'
		+'#gb{margin-top:30px!important;}'
        +'.gb_bb{top:0px!important;}'
        +'.JW,.TJb,#ID-report,#ID-reportHeader,'+youtubestyle+'{margin-top:30px!important;}'
        +'#mh{margin-top:40px!important;}'
        +'.hp #esp-gbc{padding-top:45px!important;}'
        +'#gbx3,.gbzt .gbts,#gbztms,#gbx4,#gbg,.gbzt{opacity:0!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});

}
//if active
$(function () {
	if (document.location.href.indexOf('webhp') > -1) {
		var style = ''+'.bar [href*="google.com/webhp"],.bar [href*="google.com/search?q="]{color:#'+Googlebarlinkhover+'!important;border-color:'+Googlebarbordercolor+'!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});
$(function () {
	if (document.location.href.indexOf('plus.google') > -1) {
		var style = ''+'.bar [href*="plus.google"]{color:#'+Googlebarlinkhover+'!important;border-color:'+Googlebarbordercolor+'!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});
//images
$(function () {
	if (document.location.href.indexOf('imghp') > -1) {
		var style = ''+'.bar [href*="imghp"],.bar [href*="tbm=isch"]{color:#'+Googlebarlinkhover+'!important;border-color:'+Googlebarbordercolor+'!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});
$(function () {
	if (document.location.href.indexOf('tbm=isch') > -1) {
		var style = ''+'.bar [href*="imghp"],.bar [href*="tbm=isch"]{color:#'+Googlebarlinkhover+'!important;border-color:'+Googlebarbordercolor+'!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});
//maps
$(function () {
	if (document.location.href.indexOf('maps') > -1) {
		var style = ''+'.bar [href*="maps"]{color:#'+Googlebarlinkhover+'!important;border-color:'+Googlebarbordercolor+'!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});

$(function () {
	if (document.location.href.indexOf('play.google') > -1) {
		var style = ''+'.bar [href*="play.google"]{color:#'+Googlebarlinkhover+'!important;border-color:'+Googlebarbordercolor+'!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});
$(function () {
	if (document.location.href.indexOf('youtube') > -1) {
		var style = ''+'.bar [href*="youtube"]{color:#'+Googlebarlinkhover+'!important;border-color:'+Googlebarbordercolor+'!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});

$(function () {
	if (document.location.href.indexOf('news.google') > -1) {
		var style = ''+'.bar [href*="news.google"]{color:#'+Googlebarlinkhover+'!important;border-color:'+Googlebarbordercolor+'!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});

$(function () {
	if (document.location.href.indexOf('mail.google') > -1) {
		var style = ''+'.bar [href*="mail.google"]{color:#'+Googlebarlinkhover+'!important;border-color:'+Googlebarbordercolor+'!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});

$(function () {
	if (document.location.href.indexOf('drive') > -1) {
		var style = ''+'.bar [href*="drive"]{color:#'+Googlebarlinkhover+'!important;border-color:'+Googlebarbordercolor+'!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});


$(function () {
	if (document.location.href.indexOf('calendar') > -1) {
		var style = ''+'.bar [href*="calendar"]{color:#'+Googlebarlinkhover+'!important;border-color:'+Googlebarbordercolor+'!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});

$(function () {
	if (document.location.href.indexOf('translate.google') > -1) {
		var style = ''+'.bar [href*="translate.google"]{color:#'+Googlebarlinkhover+'!important;border-color:'+Googlebarbordercolor+'!important;}';
		$('head').append('<style>' + style + '</style>');
	}
});

//embeded youtube video remove
$(function () {
	if (document.location.href.indexOf('/embed/') > -1) {

$('.Black_Nav_Bar').remove();
$('#gearicon').remove();

	}
});
//highlighted image remove
$(function () {
	if (document.location.href.indexOf('blank.html') > -1) {

$('.Black_Nav_Bar').remove();
$('#gearicon').remove();

	}
});
$(function () {
	if (document.location.href.indexOf('/share?id=') > -1) {

$('.Black_Nav_Bar').remove();
$('#gearicon').remove();

	}
});
//plus setting remove
$(function () {
	if (document.location.href.indexOf('settings/plus') > -1) {

		var style = ''+ '.ote .Black_Nav_Bar,.ote #gearicon {display:none!important;}';
		$('head').append('<style>' + style + '</style>');

	}
});

var openGM_config = function () {
	GM_config.open();
};
GM_registerMenuCommand("Google Bar Settings", openGM_config);

$('[name="q"]').keyup(function() {
var Gsearchterm = this.value;
var SearchURL = "https://www.google.com/search?q="+Gsearchterm;
$('.Black_Nav_Bar [href*="google.com/search?q"]').attr("href", SearchURL);
$('.Black_Nav_Bar [href*="/webhp"]').attr("href", SearchURL);
var ImageURL = "https://www.google.com/search?tbm=isch&q="+Gsearchterm;
$('.Black_Nav_Bar [href*="/search?tbm=isch"]').attr("href", ImageURL);
$('.Black_Nav_Bar [href*="/imghp"]').attr("href", ImageURL);
var NewsURL = "https://www.google.com/#tbm=nws&safe=off&q="+Gsearchterm;
$('.Black_Nav_Bar [href*="#tbm=nws"]').attr("href", NewsURL);
$('.Black_Nav_Bar [href*="news\.google"]').attr("href", NewsURL);
var MapsURL = "https://www.google.com/maps/preview#!q="+Gsearchterm;
$('.Black_Nav_Bar [href*="/maps"]').attr("href", MapsURL);
var PlayURL = "https://play.google.com/store/search?q="+Gsearchterm;
$('.Black_Nav_Bar [href*="play.google"]').attr("href", PlayURL);
var YouTubeURL = "https://www.youtube.com/results?search_query="+Gsearchterm;
$('.Black_Nav_Bar [href*="\.youtube\."]').attr("href", YouTubeURL);
var TranslateURL = "https://translate.google.com/#en/pr/"+Gsearchterm;
$('.Black_Nav_Bar [href*="translate\.google"]').attr("href", TranslateURL);
var WikipediaURL = "http://en.wikipedia.org/w/index.php?search="+Gsearchterm+"&title=Special%3ASearch&fulltext=1";
$('.Black_Nav_Bar [href*="\.wikipedia\."]').attr("href", WikipediaURL);
var AmazonURL = "http://www.amazon.com/s/ref=nb_sb_noss_1?url=search-alias%3Daps&field-keywords="+Gsearchterm;
$('.Black_Nav_Bar [href*="\.amazon\."]').attr("href", AmazonURL);
var EbayURL = "http://www.ebay.com/sch/i.html?_nkw="+Gsearchterm;
$('.Black_Nav_Bar [href*="\.ebay\."]').attr("href", EbayURL);
var NeweggURL = "http://www.newegg.com/Product/ProductList.aspx?Submit=ENE&Description="+Gsearchterm;
$('.Black_Nav_Bar [href*="\.newegg\."]').attr("href", NeweggURL);
var mangahereURL = "http://www.mangahere.com/search.php?name="+Gsearchterm;
$('.Black_Nav_Bar [href*="\.mangahere\."]').attr("href", mangahereURL);
var TPBURL = "http://www.thepiratebay.se/search/"+Gsearchterm;
$('.Black_Nav_Bar [href*="\.thepiratebay\."]').attr("href", TPBURL);
var WalmartURL = "http://www.walmart.com/search/search-ng.do?ic=16_0&search_query="+Gsearchterm;
$('.Black_Nav_Bar [href*="\.walmart\."]').attr("href", WalmartURL);
var nyaaURL = "http://www.nyaa.se/?page=search&cats=1_37&term="+Gsearchterm+"&sort=2";
$('.Black_Nav_Bar [href*="\.nyaa\."]').attr("href", nyaaURL);
});
$("#masthead-search-term").keyup(function() {
var Gsearchterm = this.value;
var SearchURL = "https://www.google.com/search?q="+Gsearchterm;
$('.Black_Nav_Bar [href*="google.com/search?q"]').attr("href", SearchURL);
$('.Black_Nav_Bar [href*="/webhp"]').attr("href", SearchURL);
var ImageURL = "https://www.google.com/search?tbm=isch&q="+Gsearchterm;
$('.Black_Nav_Bar [href*="/search?tbm=isch"]').attr("href", ImageURL);
$('.Black_Nav_Bar [href*="/imghp"]').attr("href", ImageURL);
var NewsURL = "https://www.google.com/#tbm=nws&safe=off&q="+Gsearchterm;
$('.Black_Nav_Bar [href*="#tbm=nws"]').attr("href", NewsURL);
$('.Black_Nav_Bar [href*="news\.google"]').attr("href", NewsURL);
var MapsURL = "https://www.google.com/maps/preview#!q="+Gsearchterm;
$('.Black_Nav_Bar [href*="/maps"]').attr("href", MapsURL);
var PlayURL = "https://play.google.com/store/search?q="+Gsearchterm;
$('.Black_Nav_Bar [href*="play.google"]').attr("href", PlayURL);
var YouTubeURL = "https://www.youtube.com/results?search_query="+Gsearchterm;
$('.Black_Nav_Bar [href*="\.youtube\."]').attr("href", YouTubeURL);
var TranslateURL = "https://translate.google.com/#en/pr/"+Gsearchterm;
$('.Black_Nav_Bar [href*="translate\.google"]').attr("href", TranslateURL);
var WikipediaURL = "http://en.wikipedia.org/w/index.php?search="+Gsearchterm+"&title=Special%3ASearch&fulltext=1";
$('.Black_Nav_Bar [href*="\.wikipedia\."]').attr("href", WikipediaURL);
var AmazonURL = "http://www.amazon.com/s/ref=nb_sb_noss_1?url=search-alias%3Daps&field-keywords="+Gsearchterm;
$('.Black_Nav_Bar [href*="\.amazon\."]').attr("href", AmazonURL);
var EbayURL = "http://www.ebay.com/sch/i.html?_nkw="+Gsearchterm;
$('.Black_Nav_Bar [href*="\.ebay\."]').attr("href", EbayURL);
var NeweggURL ="http://www.newegg.com/Product/ProductList.aspx?Submit=ENE&Description="+Gsearchterm;
$('.Black_Nav_Bar [href*="\.newegg\."]').attr("href", NeweggURL);
var mangahereURL = "http://www.mangahere.com/search.php?name="+Gsearchterm;
$('.Black_Nav_Bar [href*="\.mangahere\."]').attr("href", mangahereURL);
var TPBURL = "http://www.thepiratebay.se/search/"+Gsearchterm;
$('.Black_Nav_Bar [href*="\.thepiratebay\."]').attr("href", TPBURL);
var WalmartURL = "http://www.walmart.com/search/search-ng.do?ic=16_0&search_query="+Gsearchterm;
$('.Black_Nav_Bar [href*="\.walmart\."]').attr("href", WalmartURL);
var nyaaURL = "http://www.nyaa.se/?page=search&cats=1_37&term="+Gsearchterm+"&sort=2";
$('.Black_Nav_Bar [href*="\.nyaa\."]').attr("href", nyaaURL);
});

$(document).ready(function () {
    if ($.trim($("#masthead-search-term").val()) != "") {
    var Valueterm = $("#masthead-search-term").val();
var SearchURL2 = "https://www.google.com/search?q="+Valueterm;
$('.Black_Nav_Bar [href*="google.com/search?q"]').attr("href", SearchURL2);
$('.Black_Nav_Bar [href*="/webhp"]').attr("href", SearchURL2);
var ImageURL2 = "https://www.google.com/search?tbm=isch&q="+Valueterm;
$('.Black_Nav_Bar [href*="/search?tbm=isch"]').attr("href", ImageURL2);
$('.Black_Nav_Bar [href*="/imghp"]').attr("href", ImageURL2);
var NewsURL2 = "https://www.google.com/#tbm=nws&safe=off&q="+Valueterm;
$('.Black_Nav_Bar [href*="#tbm=nws"]').attr("href", NewsURL2);
$('.Black_Nav_Bar [href*="news\.google"]').attr("href", NewsURL2);
var MapsURL2 = "https://www.google.com/maps/preview#!q="+Valueterm;
$('.Black_Nav_Bar [href*="/maps"]').attr("href", MapsURL2);
var PlayURL2 = "https://play.google.com/store/search?q="+Valueterm;
$('.Black_Nav_Bar [href*="play.google"]').attr("href", PlayURL2);
var YouTubeURL2 = "https://www.youtube.com/results?search_query="+Valueterm;
$('.Black_Nav_Bar [href*="\.youtube\."]').attr("href", YouTubeURL2);
var TranslateURL2 = "https://translate.google.com/#en/pr/"+Valueterm;
$('.Black_Nav_Bar [href*="translate\.google"]').attr("href", TranslateURL2);
var WikipediaURL2 = "http://en.wikipedia.org/w/index.php?search="+Valueterm+"&title=Special%3ASearch&fulltext=1";
$('.Black_Nav_Bar [href*="\.wikipedia\."]').attr("href", WikipediaURL2);
var AmazonURL2 = "http://www.amazon.com/s/ref=nb_sb_noss_1?url=search-alias%3Daps&field-keywords="+Valueterm;
$('.Black_Nav_Bar [href*="\.amazon\."]').attr("href", AmazonURL2);
var EbayURL2 = "http://www.ebay.com/sch/i.html?_nkw="+Valueterm;
$('.Black_Nav_Bar [href*="\.ebay\."]').attr("href", EbayURL2);
var NeweggURL2 = "http://www.newegg.com/Product/ProductList.aspx?Submit=ENE&Description="+valueterm;
$('.Black_Nav_Bar [href*="\.newegg\."]').attr("href", NeweggURL2);
var mangahereURL2 = "http://www.mangahere.com/search.php?name="+Valueterm;
$('.Black_Nav_Bar [href*="\.mangahere\."]').attr("href", mangahereURL2);
var TPBURL2 = "http://www.thepiratebay.se/search/"+Valueterm;
$('.Black_Nav_Bar [href*="\.thepiratebay\."]').attr("href", TPBURL2);
var WalmartURL2 = "http://www.walmart.com/search/search-ng.do?ic=16_0&search_query="+Valueterm;
$('.Black_Nav_Bar [href*="\.walmart\."]').attr("href", WalmartURL2);
var nyaaURL2 = "http://www.nyaa.se/?page=search&cats=1_37&term="+Valueterm+"&sort=2";
$('.Black_Nav_Bar [href*="\.nyaa\."]').attr("href", nyaaURL2);
		}
});
$(document).ready(function () {
    if ($.trim($('[name="q"]').val()) != "") {
    var Valueterm = $('[name="q"]').val();
var SearchURL2 = "https://www.google.com/search?q="+Valueterm;
$('.Black_Nav_Bar [href*="google.com/search?q"]').attr("href", SearchURL2);
$('.Black_Nav_Bar [href*="/webhp"]').attr("href", SearchURL2);
var ImageURL2 = "https://www.google.com/search?tbm=isch&q="+Valueterm;
$('.Black_Nav_Bar [href*="/search?tbm=isch"]').attr("href", ImageURL2);
$('.Black_Nav_Bar [href*="/imghp"]').attr("href", ImageURL2);
var NewsURL2 = "https://www.google.com/#tbm=nws&safe=off&q="+Valueterm;
$('.Black_Nav_Bar [href*="#tbm=nws"]').attr("href", NewsURL2);
$('.Black_Nav_Bar [href*="news\.google"]').attr("href", NewsURL2);
var MapsURL2 = "https://www.google.com/maps/preview#!q="+Valueterm;
$('.Black_Nav_Bar [href*="/maps"]').attr("href", MapsURL2);
var PlayURL2 = "https://play.google.com/store/search?q="+Valueterm;
$('.Black_Nav_Bar [href*="play.google"]').attr("href", PlayURL2);
var YouTubeURL2 = "https://www.youtube.com/results?search_query="+Valueterm;
$('.Black_Nav_Bar [href*="\.youtube\."]').attr("href", YouTubeURL2);
var TranslateURL2 = "https://translate.google.com/#en/pr/"+Valueterm;
$('.Black_Nav_Bar [href*="translate\.google"]').attr("href", TranslateURL2);
var WikipediaURL2 = "http://en.wikipedia.org/w/index.php?search="+Valueterm+"&title=Special%3ASearch&fulltext=1";
$('.Black_Nav_Bar [href*="\.wikipedia\."]').attr("href", WikipediaURL2);
var AmazonURL2 = "http://www.amazon.com/s/ref=nb_sb_noss_1?url=search-alias%3Daps&field-keywords="+Valueterm;
$('.Black_Nav_Bar [href*="\.amazon\."]').attr("href", AmazonURL2);
var EbayURL2 = "http://www.ebay.com/sch/i.html?_nkw="+Valueterm;
$('.Black_Nav_Bar [href*="\.ebay\."]').attr("href", EbayURL2);
var NeweggURL2 = "http://www.newegg.com/Product/ProductList.aspx?Submit=ENE&Description="+valueterm;
$('.Black_Nav_Bar [href*="\.newegg\."]').attr("href", NeweggURL2);
var mangahereURL2 = "http://www.mangahere.com/search.php?name="+Valueterm;
$('.Black_Nav_Bar [href*="\.mangahere\."]').attr("href", mangahereURL2);
var TPBURL2 = "http://www.thepiratebay.se/search/"+Valueterm;
$('.Black_Nav_Bar [href*="\.thepiratebay\."]').attr("href", TPBURL2);
var WalmartURL2 = "http://www.walmart.com/search/search-ng.do?ic=16_0&search_query="+Valueterm;
$('.Black_Nav_Bar [href*="\.walmart\."]').attr("href", WalmartURL2);
var nyaaURL2 = "http://www.nyaa.se/?page=search&cats=1_37&term="+Valueterm+"&sort=2";
$('.Black_Nav_Bar [href*="\.nyaa\."]').attr("href", nyaaURL2);
}
});

